//==============================================================
//	Nom Programme	: Picky_6h
//	Date			: 9-08-2006
//	Version			: 1.0
//	Auteur			: F. Giamarchi
//
//	Description		: dfinitions des variables et constantes
//
//	1.0 (9-08-2006): configuration matrielle du robot Picky 6	
//==============================================================
//	Configuration du microcontrleur
//==============================================================
#fuses xt,nowdt,noprotect,nolvp,CCPB3,nobrownout		// Dfinitions des fusibles
//#device ICD=true
#use delay(clock=4000000)		// Frquence du quartz
//==============================================================
//	Dfinitions des constantes
//==============================================================

//==============================================================
//	Dclaration les variables globales
//==============================================================
int	Vit_Dr, Vit_Ga;
signed int	Rotation, Vitesse_Moy;
//==============================================================
//	Configuration matrielle de la carte principale
//==============================================================
#Bit Bouton = 0x05.4
#Bit Del_Verte = 0x05.4
#Bit Piezo = 0x06.3
#Bit Mot_Dr = 0x06.5
#Bit Sens_Dr = 0x06.4
#Bit Mot_Ga = 0x06.1
#Bit Sens_Ga = 0x06.2
#Bit IR = 0x06.0
//==============================================================
//	dfinitions des macros :
//==============================================================
#Define	Del_On	Del_Verte = 0;
#Define	Del_Off	Del_Verte = 1;
//==============================================================
//	Initialisations du robot 
//==============================================================
void	INIT_Robot()
{
//output_B (0x00);
set_tris_A (0x00);
set_tris_B (0x01);
port_b_pullups(true);
setup_adc(ADC_OFF);
Vit_Dr = 0;
Vit_Ga = 0;
Vitesse_Moy = 0;
Rotation = 0;
}
//==============================================================
//	Initialisation du buzzer sur PWM par RB3

//	Avec un quartz  4 MHz, on peut jouer sur le prdiviseur et PR2
//	Pour le prdiviseur on a accs  1, 4 et 16

//     (1/4000000)*4*1*128 = 128 us ou 7,812 khz
//     (1/4000000)*4*4*128 = 512 us or 2 khz
//     (1/4000000)*4*16*128= 2,048 ms or 500 hz
//==============================================================
void	INIT_Piezo()
{
	setup_ccp1(CCP_PWM);			// Configure RB3 en sortie MLI
	setup_timer_2(T2_DIV_BY_16, 127, 1);
	set_pwm1_duty(0);				// son stopp
}
//==============================================================
//	Tests du robot 
//	Tant que le bouton poussoir n'est pas activ:
//	La Del verte clignote et le buzzer sonne
//	son sur appui du bouton poussoir
//==============================================================
void	Test_Robot()
{
INIT_Piezo();
do
	{
// Clignotement de la Del verte et son
	set_pwm1_duty(64);
	Del_On;
	Delay_ms(100);
	set_pwm1_duty(0);
	Del_Off;
	Delay_ms(200);
	}
	while (Bouton);		// Test appui sur le bouton

	setup_timer_2(T2_DIV_BY_4, 127, 1);	// son  2kHz
	set_pwm1_duty(64);
	Delay_ms(100);
	set_pwm1_duty(0);
}
//==============================================================
