//==============================================================
//	Nom Programme	: Picky_6h
//	Date			: 11-08-2006
//	Version			: 1.0
//	Auteur			: F. Giamarchi
//
//	Description		: Extension LDR pour carte Picky_6
//
//	1.0 (11-08-2006): configuration matrielle et Test
//==============================================================
//	Dclaration les variables globales
//==============================================================
int	Mesure_Dr, Mesure_Ga, Max_Dr, Max_Ga, Min_Dr, Min_Ga;
long	Moyenne_Dr, Moyenne_Ga, Delta;
//==============================================================
//	Configuration matrielle de la carte principale
//==============================================================
#Bit Ldr_Dr = 0x05.0
#Bit Ldr_Ga = 0x05.1
//==============================================================
//	Mesure des deux photorsistances
//==============================================================
void	Mesure_LDR()
{
//	Slectionne le capteur Droit
	set_adc_channel(0);		// selectionne l'entre AN0
	delay_ms(1);
	Mesure_Dr = read_adc();

//	Slectionne le capteur Gauche
	set_adc_channel(1);		// selectionne l'entre AN1
	delay_ms(1);
	Mesure_Ga = read_adc();
}
//==============================================================
//	Mesure la moyenne
//==============================================================
void	Moyenne_LDR()
{
	Mesure_LDR();
//	Calcul Min, Max et Moyenne
	If (Mesure_Dr < Min_Dr)
		Min_Dr = Mesure_Dr;

	If (Mesure_Dr > Max_Dr)
		Max_Dr = Mesure_Dr;

	Moyenne_Dr = (long)Max_Dr + (long)Min_Dr;
	Moyenne_Dr >>= 1;

	If (Mesure_Ga < Min_Ga)
		Min_Ga = Mesure_Ga;

	If (Mesure_Ga > Max_Ga)
		Max_Ga = Mesure_Ga;

	Moyenne_Ga = (long)Max_Ga + (long)Min_Ga;
	Moyenne_Ga >>= 1;
}
//==============================================================
//	Routine pour mesurer les entres capteurs LDR
//==============================================================
void	Mesure_Capteurs()
{
	Moyenne_LDR();

	if (Mesure_Dr > Moyenne_Dr && Mesure_Ga > Moyenne_Ga)
	{
		Vitesse_Moy = 15;
		Rotation = 0;
		Del_On;
	}
	else if (Mesure_Dr > Moyenne_Dr)
	{
		Vitesse_Moy = 15;
		Del_On;
		Delta = Mesure_Dr - Moyenne_Dr;
		Delta >>=3;
		Rotation = -Delta;
	}
	else if (Mesure_Ga > Moyenne_Ga)
	{
		Vitesse_Moy = 15;
		Del_On;
		Delta = Mesure_Ga - Moyenne_Ga;
		Delta >>=3;
		Rotation = Delta;
	}
	else
	{
		Del_Off;
		Rotation = 0;
		Vitesse_Moy = 0;
	}
}
//==============================================================
//	Initialisations de l'extension pour capteurs LDR

// Dans l'ordre:	1 -> Configurer les lignes en entres
//					2 -> Configurer les lignes en analogiques
//					3 -> Slectionner l'horloge de conversion
//==============================================================
void	INIT_Ext_LDR()
{
	set_tris_A (0x03);
	setup_adc_ports(sAN0 | sAN1);
	setup_adc(adc_clock_internal);

	Min_Dr = 0xFF;
	Max_Dr = 0;
}
//==============================================================
