//==============================================================
//	Nom Programme	: Ext_Line.h
//	Date			: 24-09-2006
//	Version			: 1.0
//	Auteur			: F. Giamarchi
//
//	Description		: Extension Ligne pour carte Picky_6
//
//	1.0 (24-09-2006): Test suivi de Ligne
//	1.1 (07/10/2006): Ajout de moyenne indivuduelle
//==============================================================
//	Dclaration les variables globales
//==============================================================
int	G_2, G_1, D_1, D_2, Position;
long	Moy_G_2, Moy_G_1, Moy_D_1, Moy_D_2;
short	Mem_Sens;
//==============================================================
//	Mesure des deux photorsistances
//==============================================================
void	Mesure_Capt_Ligne()
{
//	Slectionne le capteur Droit
	set_adc_channel(0);		// selectionne l'entre AN0
	delay_us(20);
	D_2 = read_adc();

//	Slectionne le capteur Gauche
	set_adc_channel(1);		// selectionne l'entre AN1
	delay_us(20);
	D_1 = read_adc();

//	Slectionne le capteur Droit
	set_adc_channel(2);		// selectionne l'entre AN0
	delay_us(20);
	G_1 = read_adc();

//	Slectionne le capteur Gauche
	set_adc_channel(3);		// selectionne l'entre AN1
	delay_us(20);
	G_2 = read_adc();
	delay_us(20);
}
//==============================================================
//	Mesure la moyenne
//==============================================================

//==============================================================
//	Routine pour mesurer les entres capteurs LDR
//==============================================================
void	Mesure_Line()
{
	Mesure_Capt_Ligne();

	Position = 0;
	If (G_2 > Moy_G_2)
		Position = 1;
	If (G_1 > Moy_G_1)
		Position = Position + 2;
	If (D_1 > Moy_D_1)
		Position = Position + 4;
	If (D_2 > Moy_D_2)
		Position = Position + 8;

	if (Position == 15 || Position == 6)		// Croisement ou ligne droite
	{
		Vitesse_Moy = Consigne_Vit;
		Rotation = 0;
		Son_Stop();
	}
	else if (Position == 7)
	{
		Vitesse_Moy = Consigne_Vit -4;
		Rotation = -3;
		Mem_Sens = 1;	// Mmorise une rotation par la gauche  la prochaine pingle
		Del_On;
	}
	else if (Position == 14)
	{
		Vitesse_Moy = Consigne_Vit-4;
		Rotation = 3;
		Mem_Sens = 0;	// Mmorise une rotation par la droite  la prochaine pingle
		Del_Off;
	}
	else if (Position == 0)			// Perte de ligne
	{
		if (Mem_Sens)			// rotation par la gauche suivant l'tat de Mem_Sens
		{
			Rotation = Consigne_Vit -4;			// rduite la vitesse
			Vitesse_Moy = 0;
		}
		else
		{
			Vitesse_Moy = Consigne_Vit -4;
			Rotation = -Vitesse_Moy;
			Vitesse_Moy = 0;
		}
		Son_Init();
	}
	else if (Position == 2)			// lgrement sur la droite
	{
		Vitesse_Moy = Consigne_Vit -2;
		Rotation = Consigne_Vit -10;
		Son_Stop();
	}
	else if (Position == 4)			// lgrement sur la gauche
	{
		Vitesse_Moy = Consigne_Vit -2;
		Rotation = Consigne_Vit -10;
		Rotation = -Vitesse_Moy;
		Son_Stop();
	}
	else if (Position == 3)			// sur la droite
	{
		Vitesse_Moy = Consigne_Vit -3;
		Rotation = Consigne_Vit -5;
		Son_Stop();
	}
	else if (Position == 12)		// sur la gauche
	{
		Vitesse_Moy = Consigne_Vit-3;
		Rotation = Consigne_Vit -5;
		Rotation = -Vitesse_Moy;
		Son_Stop();
	}
	else if (Position == 1)			// Trop  droite de la ligne
	{
		Vitesse_Moy = Consigne_Vit -5;
		Rotation = Vitesse_Moy;		// vers la gauche
		Son_Init();
	 }
	else if (Position == 8)			// Trop  gauche de la ligne
	{
		Vitesse_Moy = Consigne_Vit -5;
		Rotation = -Vitesse_Moy;	// vers la droite
		Son_Init();
	}
}
//==============================================================
//	Initialisations de l'extension pour capteurs de Ligne

// Dans l'ordre:	1 -> Configurer les lignes en entres
//					2 -> Configurer les lignes en analogiques
//					3 -> Slectionner l'horloge de conversion
//
//					4 -> Calcul de la valeur moyenne dfinie comme
//					le seuil entre le noir et le blanc de la piste
//==============================================================
void	INIT_Line()
{
	set_tris_A (0x0F);
	setup_adc_ports(sAN0 | sAN1 | sAN2 | sAN3);
	setup_adc(adc_clock_internal);

Delay_ms(2000);
	Mesure_Capt_Ligne();
	Moy_G_2 = G_2;
	Moy_G_1 = G_1;
	Moy_D_1 = D_1;
	Moy_D_2 = D_2;
Son_Init();
Delay_ms(2000);
Son_Stop();

	Mesure_Capt_Ligne();
	Moy_G_2 = 	Moy_G_2 + (long)G_2;
	Moy_G_1 = 	Moy_G_1 + (long)G_1;
	Moy_D_1 = 	Moy_D_1 + (long)D_1;
	Moy_D_2 = 	Moy_D_2 + (long)D_2;

	Moy_G_2 >>= 1;
	Moy_G_1 >>= 1;
	Moy_D_1 >>= 1;
	Moy_D_2 >>= 1;
}
//==============================================================
