//------------------------------------------------------
//	Nom Programme	: RC5.h
//	Date			: 24-08-2006
// 	Description  	: Le Code RC-5 est compos de 14bits, 1.728msec par bit.
//                		Les deux premiers bits servent  ACG.
//                		Le 3me est le bit de rptation.
//                		Les 5 bits( #4..#8 ) donnent l'adresse.
//                		les 6 bits( #9..#14 ) donnent la commande.
//------------------------------------------------------
long check;
int code, adresse, Vit_Moy_RC5, Rot_RC5;
short	Code_Valide;
#byte PORTB = 6
//------------------------------------------------------
void	INIT_RC5()
{
	enable_interrupts(int_ext);
	ext_int_edge(H_to_L);
	enable_interrupts(global);
	Code_Valide = 0;
}
//------------------------------------------------------
#INT_EXT             //RB0/INT pin external interrupt
void ext_isr(void)      //RB0/INT pin external interrupt ISR
{
char i;
Vit_Dr = 0;
Vit_Ga = 0;
check = 0;
code = 0;
Del_On;
delay_us(300);

for(i=0; i<=13; i++)
	{
	if(!IR)
		check = (check << 1) + 1;
	else
		check = check << 1;
	delay_us(1730);
	}
Del_Off;

adresse = (check >> 6) & 0x1F;
if (adresse == 0 || adresse == 8)
	Code_Valide = 1;
}
//------------------------------------------------------
void	Test_Code_IR(void)
{
if (Code_Valide)
	{
	Code_Valide = 0;

	code = check & 0x3F;
	switch(code)
		{
		case 2:{Vit_Moy_RC5++; break;}					// accelere
		case 4:{Rot_RC5++; break;} 						// tourne gauche
		case 5:{Vit_Moy_RC5 = 0; Rot_RC5 = 0; break;}	// arret
		case 6:{Rot_RC5--; break;} 						// tourne droite
		case 8:{Vit_Moy_RC5--; break;} 					// ralenti
		case 12:{Vit_Moy_RC5 = 0; Rot_RC5 = 0; break;}	// arret
		}
	}
}
//------------------------------------------------------
