//---------------------------------------------------------------------------
// (C) 2005 Morin Pascal
//---------------------------------------------------------------------------
#include <vcl.h>
#include <string.h>
#pragma hdrstop

#include "Unit1.h"
#include "About.h"
#include "..\DLL\DllUsbAdc.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
//---------------------------------------------------------------------------
TForm1 *Form1;
AnsiString NomApplication="USB ADC";
unsigned int d1=0,d2=0,w1=0,w2=0,w3=0,w4=0;
int liste=0;

//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}

//---------------------------------------------------------------------------
void __fastcall TForm1::Quitter1Click(TObject *Sender)
{
CloseUSB();
Close();
}

//---------------------------------------------------------------------------
void __fastcall TForm1::APropos1Click(TObject *Sender)
{
APropos->ShowModal();
}


//---------------------------------------------------------------------------

void __fastcall TForm1::FormShow(TObject *Sender)
{
Form1->Caption=NomApplication;
if (OpenUSB())
	StatusBar1->Panels->Items[0]->Text="Connect";
else
	{
    StatusBar1->Panels->Items[0]->Text="ERR";
    Application->MessageBox("Impossible d'acceder au montage via la liaison USB","Erreur de connection",MB_OK|MB_ICONERROR);
    }

}

//---------------------------------------------------------------------------
void __fastcall TForm1::Timer2Timer(TObject *Sender)
{
unsigned int val1;
AnsiString msg;
static int ErrCount=0;

if (GetUSB(&val1,0,0,0))
	{
    Form1->StatusBar1->Panels->Items[1]->Text="OK";
	LabelADC->Caption="Val="+(AnsiString)val1;
    Series1->AddXY(Now(),val1,Time(),clTeeColor);
    if (Series1->Count()>600)
    	{
        Series1->Delete(0);
        }
    ErrCount=0;
    }
else
	{
    if (ErrCount++>2)
    	Form1->StatusBar1->Panels->Items[1]->Text="Erreur USB";
    }
}

//---------------------------------------------------------------------------
void __fastcall TForm1::ParamChange(TObject *Sender)
{
unsigned int val1;
unsigned char bipolaire;
unsigned char gain;

bipolaire=(unsigned char)CheckBox1->Checked;
gain=(unsigned char)ComboBox1->ItemIndex;
GetUSB(&val1,gain,bipolaire,0x55);
}
//---------------------------------------------------------------------------


