//---------------------------------------------------------------------------
// (C) 2005 Morin Pascal
//---------------------------------------------------------------------------
#include <vcl.h>
#include <string.h>
#pragma hdrstop

#include "Unit1.h"
#include "About.h"
#include "DllUsbBarometre.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
//---------------------------------------------------------------------------
TForm1 *Form1;
AnsiString NomApplication="Barometre USB";
unsigned int d1=0,d2=0,w1=0,w2=0,w3=0,w4=0;
int liste=0;

//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}

//---------------------------------------------------------------------------
void __fastcall TForm1::Quitter1Click(TObject *Sender)
{
CloseUSB();
Close();
}

//---------------------------------------------------------------------------
void __fastcall TForm1::APropos1Click(TObject *Sender)
{
APropos->ShowModal();
}


//---------------------------------------------------------------------------

void __fastcall TForm1::FormShow(TObject *Sender)
{
Form1->Caption=NomApplication;
if (OpenUSB())
	StatusBar1->Panels->Items[0]->Text="Connect";
else
	{
    StatusBar1->Panels->Items[0]->Text="ERR";
    Application->MessageBox("Impossible d'acceder au montage via la liaison USB","Erreur de connection",MB_OK|MB_ICONERROR);
    }

}

//---------------------------------------------------------------------------

void __fastcall TForm1::Timer1Timer(TObject *Sender)
{
static unsigned char count=0;
static float t1=0,p1=0;
unsigned int c1,c2,c3,c4,c5,c6;
float ut1,dt,temp,off,sens,p,x;

if (liste!=0x07) return;
liste=0;

c1=w1/2;
c2=(w4&0x3f)+((w3&0x3f)<<6);
c3=w4>>6;
c4=w3>>6;
c5=((w1&0x01)<<10)+((w2&0xffc0)>>6);
c6=w2&0x3f;

ut1=8*c5+20224;
if (d2>=ut1)
    {
    dt=d2-ut1;
    temp=(200+dt*(c6+50)/1024)/10;
    }
else
    {
    dt=(d2-ut1)-((d2-ut1)/128)*((d2-ut1)/128)/4;
    temp=(200+dt*(c6+50)/1024+dt/256)/10;
    }
off=c2*4+((c4-512)*dt)/4096;
sens=c1+(c3*dt)/1024+24576;
x=(sens*(d1-7168))/16384-off;
p=x*10/32+250*10;
p=p/10;

LabelTemperature->Caption="Temp="+FormatFloat("0.0",temp)+" C";
LabelPression->Caption="Pression="+FormatFloat("0.0",p)+" mbars";

p1+=p;
t1+=temp;
count++;
if (count>=8)
    {
    Series1->AddXY(Now(),t1/8,Now(),clTeeColor);
    Series2->AddXY(Now(),p1/8,Now(),clTeeColor);
    p1=0;
    t1=0;
    count=0;
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Timer2Timer(TObject *Sender)
{
unsigned char indice;
unsigned int val1,val2;
AnsiString msg;
static int ErrCount=0;

if (GetUSB(&indice,&val1,&val2))
	{
    Form1->StatusBar1->Panels->Items[1]->Text="OK";
    ErrCount=0;
    switch(indice)
    	{
		case	0x01:
						w1=val1;
                        w2=val2;
                        liste|=0x01;
        				break;
		case	0x02:
						w3=val1;
                        w4=val2;
                        liste|=0x02;
        				break;
		case	0x03:
						d1=val1;
                        d2=val2;
                        liste|=0x04;
        				break;
        }
    }
else
	{
    if (ErrCount++>2)
    	Form1->StatusBar1->Panels->Items[1]->Text="Erreur USB";
    }
}


