/** ###################################################################
**     THIS BEAN MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : IO_Map.H
**     Project   : oscillateur
**     Processor : MC68HC908QT1CP
**     Beantype  : IO_Map
**     Version   : Driver 01.06
**     Compiler  : Metrowerks HC08 C Compiler
**     Date/Time : 08/02/2005, 18:55
**     Abstract  :
**         IO_Map.h - implements an IO devices mapping. 
**         This module contains symbol definitions of all peripheral 
**         registers and bits. 
**     Settings  :
**
**     Contents  :
**         No public methods
**
**     (c) Copyright UNIS, spol. s r.o. 1997-2004
**     UNIS, spol. s r.o.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/

#ifndef _IO_MAP_H
#define _IO_MAP_H
/* Based on CPU DB MC68HC908QT1, version 2.87.099 (RegistersPrg V1.085) */
/* DataSheet : MC68HC908QY4/D Rev 3.0 1/2004 */

#include "PE_Types.h"

#pragma MESSAGE DISABLE C1106 /* WARNING C1106: Non-standard bitfield type */

/*********************************************/
/*                                           */
/* PE I/O map                                */
/*                                           */
/*********************************************/

/**************** interrupt vector table ****************/
#define INT_KBI                 0x0000FFE0
#define Reserved1               0x0000FFE2
#define Reserved2               0x0000FFE4
#define Reserved3               0x0000FFE6
#define Reserved4               0x0000FFE8
#define Reserved5               0x0000FFEA
#define Reserved6               0x0000FFEC
#define Reserved7               0x0000FFEE
#define Reserved8               0x0000FFF0
#define INT_TIMOvr              0x0000FFF2
#define INT_TIMCH1              0x0000FFF4
#define INT_TIMCH0              0x0000FFF6
#define Reserved12              0x0000FFF8
#define INT_IRQ                 0x0000FFFA
#define INT_SWI                 0x0000FFFC
#define INT_RESET               0x0000FFFE

/**************** registers I/O map ****************/

/*** PTA - Port A Data Register; 0x00000000 ***/
typedef union {
  byte Byte;
  struct {
    byte PTA0        :1;                                       /* Port A Data Bit 0 */
    byte PTA1        :1;                                       /* Port A Data Bit 1 */
    byte PTA2        :1;                                       /* Port A Data Bit 2 */
    byte PTA3        :1;                                       /* Port A Data Bit 3 */
    byte PTA4        :1;                                       /* Port A Data Bit 4 */
    byte PTA5        :1;                                       /* Port A Data Bit 5 */
    byte AWUL        :1;                                       /* Auto Wake-up Latch Data Bit */
    byte             :1; 
  } Bits;
  struct {
    byte grpPTA  :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTASTR;
extern volatile PTASTR _PTA @0x00000000;
#define PTA                             _PTA.Byte
#define PTA_PTA0                        _PTA.Bits.PTA0
#define PTA_PTA1                        _PTA.Bits.PTA1
#define PTA_PTA2                        _PTA.Bits.PTA2
#define PTA_PTA3                        _PTA.Bits.PTA3
#define PTA_PTA4                        _PTA.Bits.PTA4
#define PTA_PTA5                        _PTA.Bits.PTA5
#define PTA_AWUL                        _PTA.Bits.AWUL
#define PTA_PTA                         _PTA.MergedBits.grpPTA

#define PTA_PTA0_MASK                   1
#define PTA_PTA1_MASK                   2
#define PTA_PTA2_MASK                   4
#define PTA_PTA3_MASK                   8
#define PTA_PTA4_MASK                   16
#define PTA_PTA5_MASK                   32
#define PTA_AWUL_MASK                   64
#define PTA_PTA_MASK                    63
#define PTA_PTA_BITNUM                  0


/*** DDRA - Data Direction Register A; 0x00000004 ***/
typedef union {
  byte Byte;
  struct {
    byte DDRA0       :1;                                       /* Data Direction Register A Bit 0 */
    byte DDRA1       :1;                                       /* Data Direction Register A Bit 1 */
    byte             :1; 
    byte DDRA3       :1;                                       /* Data Direction Register A Bit 3 */
    byte DDRA4       :1;                                       /* Data Direction Register A Bit 4 */
    byte DDRA5       :1;                                       /* Data Direction Register A Bit 5 */
    byte             :1; 
    byte             :1; 
  } Bits;
  struct {
    byte grpDDRA :2;
    byte         :1;
    byte grpDDRA_3 :3;
    byte         :1;
    byte         :1;
  } MergedBits;
} DDRASTR;
extern volatile DDRASTR _DDRA @0x00000004;
#define DDRA                            _DDRA.Byte
#define DDRA_DDRA0                      _DDRA.Bits.DDRA0
#define DDRA_DDRA1                      _DDRA.Bits.DDRA1
#define DDRA_DDRA3                      _DDRA.Bits.DDRA3
#define DDRA_DDRA4                      _DDRA.Bits.DDRA4
#define DDRA_DDRA5                      _DDRA.Bits.DDRA5
#define DDRA_DDRA                       _DDRA.MergedBits.grpDDRA
#define DDRA_DDRA_3                     _DDRA.MergedBits.grpDDRA_3

#define DDRA_DDRA0_MASK                 1
#define DDRA_DDRA1_MASK                 2
#define DDRA_DDRA3_MASK                 8
#define DDRA_DDRA4_MASK                 16
#define DDRA_DDRA5_MASK                 32
#define DDRA_DDRA_MASK                  3
#define DDRA_DDRA_BITNUM                0
#define DDRA_DDRA_3_MASK                56
#define DDRA_DDRA_3_BITNUM              3


/*** PTAPUE - Input Pull-Up Enable Register PTAPUE; 0x0000000B ***/
typedef union {
  byte Byte;
  struct {
    byte PTAPUE0     :1;                                       /* Pull-Up Enable bit 0, Port A */
    byte PTAPUE1     :1;                                       /* Pull-Up Enable bit 1, Port A */
    byte PTAPUE2     :1;                                       /* Pull-Up Enable bit 2, Port A */
    byte PTAPUE3     :1;                                       /* Pull-Up Enable bit 3, Port A */
    byte PTAPUE4     :1;                                       /* Pull-Up Enable bit 4, Port A */
    byte PTAPUE5     :1;                                       /* Pull-Up Enable bit 5, Port A */
    byte             :1; 
    byte OSC2EN      :1;                                       /* Enable PTA4 on OSC2 Pin */
  } Bits;
  struct {
    byte grpPTAPUE :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} PTAPUESTR;
extern volatile PTAPUESTR _PTAPUE @0x0000000B;
#define PTAPUE                          _PTAPUE.Byte
#define PTAPUE_PTAPUE0                  _PTAPUE.Bits.PTAPUE0
#define PTAPUE_PTAPUE1                  _PTAPUE.Bits.PTAPUE1
#define PTAPUE_PTAPUE2                  _PTAPUE.Bits.PTAPUE2
#define PTAPUE_PTAPUE3                  _PTAPUE.Bits.PTAPUE3
#define PTAPUE_PTAPUE4                  _PTAPUE.Bits.PTAPUE4
#define PTAPUE_PTAPUE5                  _PTAPUE.Bits.PTAPUE5
#define PTAPUE_OSC2EN                   _PTAPUE.Bits.OSC2EN
#define PTAPUE_PTAPUE                   _PTAPUE.MergedBits.grpPTAPUE

#define PTAPUE_PTAPUE0_MASK             1
#define PTAPUE_PTAPUE1_MASK             2
#define PTAPUE_PTAPUE2_MASK             4
#define PTAPUE_PTAPUE3_MASK             8
#define PTAPUE_PTAPUE4_MASK             16
#define PTAPUE_PTAPUE5_MASK             32
#define PTAPUE_OSC2EN_MASK              128
#define PTAPUE_PTAPUE_MASK              63
#define PTAPUE_PTAPUE_BITNUM            0


/*** KBSCR - Keyboard Status and Control Register; 0x0000001A ***/
typedef union {
  byte Byte;
  struct {
    byte MODEK       :1;                                       /* Keyboard Triggering Sensitivity Bit */
    byte IMASKK      :1;                                       /* Keyboard Interrupt Mask Bit */
    byte ACKK        :1;                                       /* Keyboard Acknowledge Bit */
    byte KEYF        :1;                                       /* Keyboard Flag Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} KBSCRSTR;
extern volatile KBSCRSTR _KBSCR @0x0000001A;
#define KBSCR                           _KBSCR.Byte
#define KBSCR_MODEK                     _KBSCR.Bits.MODEK
#define KBSCR_IMASKK                    _KBSCR.Bits.IMASKK
#define KBSCR_ACKK                      _KBSCR.Bits.ACKK
#define KBSCR_KEYF                      _KBSCR.Bits.KEYF

#define KBSCR_MODEK_MASK                1
#define KBSCR_IMASKK_MASK               2
#define KBSCR_ACKK_MASK                 4
#define KBSCR_KEYF_MASK                 8


/*** KBIER - Keyboard Interrrupt Enable Register KBIER; 0x0000001B ***/
typedef union {
  byte Byte;
  struct {
    byte KBIE0       :1;                                       /* Keyboard Interrupt Enable Bit 0 */
    byte KBIE1       :1;                                       /* Keyboard Interrupt Enable Bit 1 */
    byte KBIE2       :1;                                       /* Keyboard Interrupt Enable Bit 2 */
    byte KBIE3       :1;                                       /* Keyboard Interrupt Enable Bit 3 */
    byte KBIE4       :1;                                       /* Keyboard Interrupt Enable Bit 4 */
    byte KBIE5       :1;                                       /* Keyboard Interrupt Enable Bit 5 */
    byte AWUIE       :1;                                       /* Auto Wake-up Interrupt Enable Bit */
    byte             :1; 
  } Bits;
  struct {
    byte grpKBIE :6;
    byte         :1;
    byte         :1;
  } MergedBits;
} KBIERSTR;
extern volatile KBIERSTR _KBIER @0x0000001B;
#define KBIER                           _KBIER.Byte
#define KBIER_KBIE0                     _KBIER.Bits.KBIE0
#define KBIER_KBIE1                     _KBIER.Bits.KBIE1
#define KBIER_KBIE2                     _KBIER.Bits.KBIE2
#define KBIER_KBIE3                     _KBIER.Bits.KBIE3
#define KBIER_KBIE4                     _KBIER.Bits.KBIE4
#define KBIER_KBIE5                     _KBIER.Bits.KBIE5
#define KBIER_AWUIE                     _KBIER.Bits.AWUIE
#define KBIER_KBIE                      _KBIER.MergedBits.grpKBIE

#define KBIER_KBIE0_MASK                1
#define KBIER_KBIE1_MASK                2
#define KBIER_KBIE2_MASK                4
#define KBIER_KBIE3_MASK                8
#define KBIER_KBIE4_MASK                16
#define KBIER_KBIE5_MASK                32
#define KBIER_AWUIE_MASK                64
#define KBIER_KBIE_MASK                 63
#define KBIER_KBIE_BITNUM               0


/*** INTSCR - IRQ Status and Control Register; 0x0000001D ***/
typedef union {
  byte Byte;
  struct {
    byte MODE        :1;                                       /* IRQ Edge/Level Select Bit */
    byte IMASK       :1;                                       /* IRQ Interrupt Mask Bit */
    byte ACK         :1;                                       /* IRQ Interrupt Request Acknowledge Bit */
    byte IRQF        :1;                                       /* IRQ Flag Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} INTSCRSTR;
extern volatile INTSCRSTR _INTSCR @0x0000001D;
#define INTSCR                          _INTSCR.Byte
#define INTSCR_MODE                     _INTSCR.Bits.MODE
#define INTSCR_IMASK                    _INTSCR.Bits.IMASK
#define INTSCR_ACK                      _INTSCR.Bits.ACK
#define INTSCR_IRQF                     _INTSCR.Bits.IRQF

#define INTSCR_MODE_MASK                1
#define INTSCR_IMASK_MASK               2
#define INTSCR_ACK_MASK                 4
#define INTSCR_IRQF_MASK                8


/*** CONFIG2 - Configuration Register 2; 0x0000001E ***/
typedef union {
  byte Byte;
  struct {
    byte RSTEN       :1;                                       /* RST Pin Function Selection */
    byte             :1; 
    byte             :1; 
    byte OSCOPT0     :1;                                       /* Selection Bits for Oscillator Option 0 */
    byte OSCOPT1     :1;                                       /* Selection Bits for Oscillator Option 1 */
    byte             :1; 
    byte IRQEN       :1;                                       /* IRQ Pin Function Selection Bit */
    byte IRQPUD      :1;                                       /* IRQ Pin Pullup Control Bit */
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte         :1;
    byte grpOSCOPT :2;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} CONFIG2STR;
extern volatile CONFIG2STR _CONFIG2 @0x0000001E;
#define CONFIG2                         _CONFIG2.Byte
#define CONFIG2_RSTEN                   _CONFIG2.Bits.RSTEN
#define CONFIG2_OSCOPT0                 _CONFIG2.Bits.OSCOPT0
#define CONFIG2_OSCOPT1                 _CONFIG2.Bits.OSCOPT1
#define CONFIG2_IRQEN                   _CONFIG2.Bits.IRQEN
#define CONFIG2_IRQPUD                  _CONFIG2.Bits.IRQPUD
#define CONFIG2_OSCOPT                  _CONFIG2.MergedBits.grpOSCOPT

#define CONFIG2_RSTEN_MASK              1
#define CONFIG2_OSCOPT0_MASK            8
#define CONFIG2_OSCOPT1_MASK            16
#define CONFIG2_IRQEN_MASK              64
#define CONFIG2_IRQPUD_MASK             128
#define CONFIG2_OSCOPT_MASK             24
#define CONFIG2_OSCOPT_BITNUM           3


/*** CONFIG1 - Configuration Register 1; 0x0000001F ***/
typedef union {
  byte Byte;
  struct {
    byte COPD        :1;                                       /* COP Disable Bit */
    byte STOP        :1;                                       /* STOP Instruction Enable Bit */
    byte SSREC       :1;                                       /* Short Stop Recovery Bit */
    byte LVI5OR3     :1;                                       /* LVI 5-V or 3-V Operating Mode Bit */
    byte LVIPWRD     :1;                                       /* Low Voltage Inhibit Power Disable Bit */
    byte LVIRSTD     :1;                                       /* Low Voltage Inhibit Reset Disable Bit */
    byte LVISTOP     :1;                                       /* LVI Enable in Stop Mode Bit */
    byte COPRS       :1;                                       /* COP Reset Period Selection Bit */
  } Bits;
} CONFIG1STR;
extern volatile CONFIG1STR _CONFIG1 @0x0000001F;
#define CONFIG1                         _CONFIG1.Byte
#define CONFIG1_COPD                    _CONFIG1.Bits.COPD
#define CONFIG1_STOP                    _CONFIG1.Bits.STOP
#define CONFIG1_SSREC                   _CONFIG1.Bits.SSREC
#define CONFIG1_LVI5OR3                 _CONFIG1.Bits.LVI5OR3
#define CONFIG1_LVIPWRD                 _CONFIG1.Bits.LVIPWRD
#define CONFIG1_LVIRSTD                 _CONFIG1.Bits.LVIRSTD
#define CONFIG1_LVISTOP                 _CONFIG1.Bits.LVISTOP
#define CONFIG1_COPRS                   _CONFIG1.Bits.COPRS

#define CONFIG1_COPD_MASK               1
#define CONFIG1_STOP_MASK               2
#define CONFIG1_SSREC_MASK              4
#define CONFIG1_LVI5OR3_MASK            8
#define CONFIG1_LVIPWRD_MASK            16
#define CONFIG1_LVIRSTD_MASK            32
#define CONFIG1_LVISTOP_MASK            64
#define CONFIG1_COPRS_MASK              128


/*** TSC - TIM Status and Control Register TSC; 0x00000020 ***/
typedef union {
  byte Byte;
  struct {
    byte PS0         :1;                                       /* Prescaler Select Bit 0 */
    byte PS1         :1;                                       /* Prescaler Select Bit 1 */
    byte PS2         :1;                                       /* Prescaler Select Bit 2 */
    byte             :1; 
    byte TRST        :1;                                       /* TIM Reset Bit */
    byte TSTOP       :1;                                       /* TIM Stop Bit */
    byte TOIE        :1;                                       /* TIM Overflow Interrupt Enable Bit */
    byte TOF         :1;                                       /* TIM Overflow Flag Bit */
  } Bits;
  struct {
    byte grpPS   :3;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} TSCSTR;
extern volatile TSCSTR _TSC @0x00000020;
#define TSC                             _TSC.Byte
#define TSC_PS0                         _TSC.Bits.PS0
#define TSC_PS1                         _TSC.Bits.PS1
#define TSC_PS2                         _TSC.Bits.PS2
#define TSC_TRST                        _TSC.Bits.TRST
#define TSC_TSTOP                       _TSC.Bits.TSTOP
#define TSC_TOIE                        _TSC.Bits.TOIE
#define TSC_TOF                         _TSC.Bits.TOF
#define TSC_PS                          _TSC.MergedBits.grpPS

#define TSC_PS0_MASK                    1
#define TSC_PS1_MASK                    2
#define TSC_PS2_MASK                    4
#define TSC_TRST_MASK                   16
#define TSC_TSTOP_MASK                  32
#define TSC_TOIE_MASK                   64
#define TSC_TOF_MASK                    128
#define TSC_PS_MASK                     7
#define TSC_PS_BITNUM                   0


/*** TCNT - TIM Counter Register; 0x00000021 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TCNTH - TIM Counter Register High; 0x00000021 ***/
    union {
      byte Byte;
    } TCNTHSTR;
    #define TCNTH                       _TCNT.Overlap_STR.TCNTHSTR.Byte
    
    


    /*** TCNTL - TIM Counter Register Low; 0x00000022 ***/
    union {
      byte Byte;
    } TCNTLSTR;
    #define TCNTL                       _TCNT.Overlap_STR.TCNTLSTR.Byte
    
    

  } Overlap_STR;

} TCNTSTR;
extern volatile TCNTSTR _TCNT @0x00000021;
#define TCNT                            _TCNT.Word



/*** TMOD - TIM Counter Modulo Register; 0x00000023 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TMODH - TIM Counter Modulo Register High; 0x00000023 ***/
    union {
      byte Byte;
    } TMODHSTR;
    #define TMODH                       _TMOD.Overlap_STR.TMODHSTR.Byte
    
    


    /*** TMODL - TIM Counter Modulo Register Low; 0x00000024 ***/
    union {
      byte Byte;
    } TMODLSTR;
    #define TMODL                       _TMOD.Overlap_STR.TMODLSTR.Byte
    
    

  } Overlap_STR;

} TMODSTR;
extern volatile TMODSTR _TMOD @0x00000023;
#define TMOD                            _TMOD.Word



/*** TSC0 - TIM Channel 0 Status and Control Register; 0x00000025 ***/
typedef union {
  byte Byte;
  struct {
    byte CH0MAX      :1;                                       /* Channel 0 Maximum Duty Cycle Bit */
    byte TOV0        :1;                                       /* Toggle-On-Overflow Bit */
    byte ELS0A       :1;                                       /* Edge/Level Select Bit A */
    byte ELS0B       :1;                                       /* Edge/Level Select Bit B */
    byte MS0A        :1;                                       /* Mode Select Bit A */
    byte MS0B        :1;                                       /* Mode Select Bit B */
    byte CH0IE       :1;                                       /* Channel 0 Interrupt Enable Bit */
    byte CH0F        :1;                                       /* Channel 0 Flag Bit */
  } Bits;
  struct {
    byte         :1;
    byte grpTOV  :1;
    byte grpELS0x :2;
    byte grpMS0x :2;
    byte         :1;
    byte         :1;
  } MergedBits;
} TSC0STR;
extern volatile TSC0STR _TSC0 @0x00000025;
#define TSC0                            _TSC0.Byte
#define TSC0_CH0MAX                     _TSC0.Bits.CH0MAX
#define TSC0_TOV0                       _TSC0.Bits.TOV0
#define TSC0_ELS0A                      _TSC0.Bits.ELS0A
#define TSC0_ELS0B                      _TSC0.Bits.ELS0B
#define TSC0_MS0A                       _TSC0.Bits.MS0A
#define TSC0_MS0B                       _TSC0.Bits.MS0B
#define TSC0_CH0IE                      _TSC0.Bits.CH0IE
#define TSC0_CH0F                       _TSC0.Bits.CH0F
#define TSC0_ELS0x                      _TSC0.MergedBits.grpELS0x
#define TSC0_MS0x                       _TSC0.MergedBits.grpMS0x

#define TSC0_CH0MAX_MASK                1
#define TSC0_TOV0_MASK                  2
#define TSC0_ELS0A_MASK                 4
#define TSC0_ELS0B_MASK                 8
#define TSC0_MS0A_MASK                  16
#define TSC0_MS0B_MASK                  32
#define TSC0_CH0IE_MASK                 64
#define TSC0_CH0F_MASK                  128
#define TSC0_ELS0x_MASK                 12
#define TSC0_ELS0x_BITNUM               2
#define TSC0_MS0x_MASK                  48
#define TSC0_MS0x_BITNUM                4


/*** TCH0 - TIM Channel 0 Register; 0x00000026 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TCH0H - TIM Channel 0 Register High; 0x00000026 ***/
    union {
      byte Byte;
    } TCH0HSTR;
    #define TCH0H                       _TCH0.Overlap_STR.TCH0HSTR.Byte
    
    


    /*** TCH0L - TIM Channel 0 Register Low; 0x00000027 ***/
    union {
      byte Byte;
    } TCH0LSTR;
    #define TCH0L                       _TCH0.Overlap_STR.TCH0LSTR.Byte
    
    

  } Overlap_STR;

} TCH0STR;
extern volatile TCH0STR _TCH0 @0x00000026;
#define TCH0                            _TCH0.Word
/* TCH_ARR: Access 2 TCHx registers in a array */
#define TCH_ARR                         ((Word *) &TCH0)



/*** TSC1 - TIM Channel 1 Status and Control Register; 0x00000028 ***/
typedef union {
  byte Byte;
  struct {
    byte CH1MAX      :1;                                       /* Channel 1 Maximum Duty Cycle Bit */
    byte TOV1        :1;                                       /* Toggle-On-Overflow Bit */
    byte ELS1A       :1;                                       /* Edge/Level Select Bit A */
    byte ELS1B       :1;                                       /* Edge/Level Select Bit B */
    byte MS1A        :1;                                       /* Mode Select Bit A */
    byte             :1; 
    byte CH1IE       :1;                                       /* Channel 1 Interrupt Enable Bit */
    byte CH1F        :1;                                       /* Channel 1 Flag Bit */
  } Bits;
  struct {
    byte         :1;
    byte grpTOV_1 :1;
    byte grpELS1x :2;
    byte grpMS1x :1;
    byte         :1;
    byte         :1;
    byte         :1;
  } MergedBits;
} TSC1STR;
extern volatile TSC1STR _TSC1 @0x00000028;
#define TSC1                            _TSC1.Byte
#define TSC1_CH1MAX                     _TSC1.Bits.CH1MAX
#define TSC1_TOV1                       _TSC1.Bits.TOV1
#define TSC1_ELS1A                      _TSC1.Bits.ELS1A
#define TSC1_ELS1B                      _TSC1.Bits.ELS1B
#define TSC1_MS1A                       _TSC1.Bits.MS1A
#define TSC1_CH1IE                      _TSC1.Bits.CH1IE
#define TSC1_CH1F                       _TSC1.Bits.CH1F
#define TSC1_ELS1x                      _TSC1.MergedBits.grpELS1x

#define TSC1_CH1MAX_MASK                1
#define TSC1_TOV1_MASK                  2
#define TSC1_ELS1A_MASK                 4
#define TSC1_ELS1B_MASK                 8
#define TSC1_MS1A_MASK                  16
#define TSC1_CH1IE_MASK                 64
#define TSC1_CH1F_MASK                  128
#define TSC1_ELS1x_MASK                 12
#define TSC1_ELS1x_BITNUM               2


/*** TCH1 - TIM Channel 1 Register; 0x00000029 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** TCH1H - TIM Channel 1 Register High; 0x00000029 ***/
    union {
      byte Byte;
    } TCH1HSTR;
    #define TCH1H                       _TCH1.Overlap_STR.TCH1HSTR.Byte
    
    


    /*** TCH1L - TIM Channel 1 Register Low; 0x0000002A ***/
    union {
      byte Byte;
    } TCH1LSTR;
    #define TCH1L                       _TCH1.Overlap_STR.TCH1LSTR.Byte
    
    

  } Overlap_STR;

} TCH1STR;
extern volatile TCH1STR _TCH1 @0x00000029;
#define TCH1                            _TCH1.Word



/*** OSCSTAT - Oscillator Status Register; 0x00000036 ***/
typedef union {
  byte Byte;
  struct {
    byte ECGST       :1;                                       /* External Clock Status Bit */
    byte ECGON       :1;                                       /* External Clock Generator On Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} OSCSTATSTR;
extern volatile OSCSTATSTR _OSCSTAT @0x00000036;
#define OSCSTAT                         _OSCSTAT.Byte
#define OSCSTAT_ECGST                   _OSCSTAT.Bits.ECGST
#define OSCSTAT_ECGON                   _OSCSTAT.Bits.ECGON

#define OSCSTAT_ECGST_MASK              1
#define OSCSTAT_ECGON_MASK              2


/*** OSCTRIM - Oscillator Trim Register; 0x00000038 ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* ICG Trim Factor Bit 0 */
    byte BIT1        :1;                                       /* ICG Trim Factor Bit 1 */
    byte BIT2        :1;                                       /* ICG Trim Factor Bit 2 */
    byte BIT3        :1;                                       /* ICG Trim Factor Bit 3 */
    byte BIT4        :1;                                       /* ICG Trim Factor Bit 4 */
    byte BIT5        :1;                                       /* ICG Trim Factor Bit 5 */
    byte BIT6        :1;                                       /* ICG Trim Factor Bit 6 */
    byte BIT7        :1;                                       /* ICG Trim Factor Bit 7 */
  } Bits;
} OSCTRIMSTR;
extern volatile OSCTRIMSTR _OSCTRIM @0x00000038;
#define OSCTRIM                         _OSCTRIM.Byte
#define OSCTRIM_BIT0                    _OSCTRIM.Bits.BIT0
#define OSCTRIM_BIT1                    _OSCTRIM.Bits.BIT1
#define OSCTRIM_BIT2                    _OSCTRIM.Bits.BIT2
#define OSCTRIM_BIT3                    _OSCTRIM.Bits.BIT3
#define OSCTRIM_BIT4                    _OSCTRIM.Bits.BIT4
#define OSCTRIM_BIT5                    _OSCTRIM.Bits.BIT5
#define OSCTRIM_BIT6                    _OSCTRIM.Bits.BIT6
#define OSCTRIM_BIT7                    _OSCTRIM.Bits.BIT7

#define OSCTRIM_BIT0_MASK               1
#define OSCTRIM_BIT1_MASK               2
#define OSCTRIM_BIT2_MASK               4
#define OSCTRIM_BIT3_MASK               8
#define OSCTRIM_BIT4_MASK               16
#define OSCTRIM_BIT5_MASK               32
#define OSCTRIM_BIT6_MASK               64
#define OSCTRIM_BIT7_MASK               128


/*** SBSR - Break Status Register; 0x0000FE00 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte SBSW        :1;                                       /* SIM Break Stop/Wait */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} SBSRSTR;
extern volatile SBSRSTR _SBSR @0x0000FE00;
#define SBSR                            _SBSR.Byte
#define SBSR_SBSW                       _SBSR.Bits.SBSW

#define SBSR_SBSW_MASK                  2


/*** SRSR - SIM Reset Status Register; 0x0000FE01 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte LVI         :1;                                       /* Low-Voltage Inhibit Reset Bit */
    byte MODRST      :1;                                       /* Monitor Mode Entry Module Reset bit */
    byte ILAD        :1;                                       /* Illegal Address Reset Bit (opcode fetches only) */
    byte ILOP        :1;                                       /* Illegal Opcode Reset Bit */
    byte COP         :1;                                       /* Computer Operating Properly Reset Bit */
    byte PIN         :1;                                       /* External Reset Bit */
    byte POR         :1;                                       /* Power-On Reset Bit */
  } Bits;
} SRSRSTR;
extern volatile SRSRSTR _SRSR @0x0000FE01;
#define SRSR                            _SRSR.Byte
#define SRSR_LVI                        _SRSR.Bits.LVI
#define SRSR_MODRST                     _SRSR.Bits.MODRST
#define SRSR_ILAD                       _SRSR.Bits.ILAD
#define SRSR_ILOP                       _SRSR.Bits.ILOP
#define SRSR_COP                        _SRSR.Bits.COP
#define SRSR_PIN                        _SRSR.Bits.PIN
#define SRSR_POR                        _SRSR.Bits.POR

#define SRSR_LVI_MASK                   2
#define SRSR_MODRST_MASK                4
#define SRSR_ILAD_MASK                  8
#define SRSR_ILOP_MASK                  16
#define SRSR_COP_MASK                   32
#define SRSR_PIN_MASK                   64
#define SRSR_POR_MASK                   128


/*** BRKAR - Break Auxiliary Register; 0x0000FE02 ***/
typedef union {
  byte Byte;
  struct {
    byte BDCOP       :1;                                       /* Break Disable COP Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} BRKARSTR;
extern volatile BRKARSTR _BRKAR @0x0000FE02;
#define BRKAR                           _BRKAR.Byte
#define BRKAR_BDCOP                     _BRKAR.Bits.BDCOP

#define BRKAR_BDCOP_MASK                1


/*** BFCR - SIM Break Flag Control Register; 0x0000FE03 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte BCFE        :1;                                       /* Break Clear Flag Enable Bit */
  } Bits;
} BFCRSTR;
extern volatile BFCRSTR _BFCR @0x0000FE03;
#define BFCR                            _BFCR.Byte
#define BFCR_BCFE                       _BFCR.Bits.BCFE

#define BFCR_BCFE_MASK                  128


/*** INT1 - Interrupt Status Register 1; 0x0000FE04 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte IF1         :1;                                       /* Interrupt Flag 1 */
    byte             :1; 
    byte IF3         :1;                                       /* Interrupt Flag 3 */
    byte IF4         :1;                                       /* Interrupt Flag 4 */
    byte IF5         :1;                                       /* Interrupt Flag 5 */
    byte             :1; 
  } Bits;
  struct {
    byte         :1;
    byte         :1;
    byte grpIF_1 :1;
    byte         :1;
    byte grpIF_3 :3;
    byte         :1;
  } MergedBits;
} INT1STR;
extern volatile INT1STR _INT1 @0x0000FE04;
#define INT1                            _INT1.Byte
#define INT1_IF1                        _INT1.Bits.IF1
#define INT1_IF3                        _INT1.Bits.IF3
#define INT1_IF4                        _INT1.Bits.IF4
#define INT1_IF5                        _INT1.Bits.IF5
#define INT1_IF_3                       _INT1.MergedBits.grpIF_3
#define INT1_IF                         INT1_IF_3

#define INT1_IF1_MASK                   4
#define INT1_IF3_MASK                   16
#define INT1_IF4_MASK                   32
#define INT1_IF5_MASK                   64
#define INT1_IF_3_MASK                  112
#define INT1_IF_3_BITNUM                4


/*** INT2 - Interrupt Status Register 2; 0x0000FE05 ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte IF14        :1;                                       /* Interrupt Flag 14 */
  } Bits;
} INT2STR;
extern volatile INT2STR _INT2 @0x0000FE05;
#define INT2                            _INT2.Byte
#define INT2_IF14                       _INT2.Bits.IF14

#define INT2_IF14_MASK                  128


/*** INT3 - Interrupt Status Register 3; 0x0000FE06 ***/
typedef union {
  byte Byte;
  struct {
    byte IF15        :1;                                       /* Interrupt Flag 15 */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} INT3STR;
extern volatile INT3STR _INT3 @0x0000FE06;
#define INT3                            _INT3.Byte
#define INT3_IF15                       _INT3.Bits.IF15

#define INT3_IF15_MASK                  1


/*** FLCR - FLASH Control Register; 0x0000FE08 ***/
typedef union {
  byte Byte;
  struct {
    byte PGM         :1;                                       /* Program Control Bit */
    byte ERASE       :1;                                       /* Erase Control Bit */
    byte MASS        :1;                                       /* Mass Erase Control Bit */
    byte HVEN        :1;                                       /* High-Voltage Enable Bit */
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
  } Bits;
} FLCRSTR;
extern volatile FLCRSTR _FLCR @0x0000FE08;
#define FLCR                            _FLCR.Byte
#define FLCR_PGM                        _FLCR.Bits.PGM
#define FLCR_ERASE                      _FLCR.Bits.ERASE
#define FLCR_MASS                       _FLCR.Bits.MASS
#define FLCR_HVEN                       _FLCR.Bits.HVEN

#define FLCR_PGM_MASK                   1
#define FLCR_ERASE_MASK                 2
#define FLCR_MASS_MASK                  4
#define FLCR_HVEN_MASK                  8


/*** BRK - Break Address Register; 0x0000FE09 ***/
typedef union {
  word Word;
   /* Overlapped registers: */
  struct {
    /*** BRKH - Break Address Register High; 0x0000FE09 ***/
    union {
      byte Byte;
      struct {
        byte BIT8        :1;                                       /* Break Address Register Bit 8 */
        byte BIT9        :1;                                       /* Break Address Register Bit 9 */
        byte BIT10       :1;                                       /* Break Address Register Bit 10 */
        byte BIT11       :1;                                       /* Break Address Register Bit 11 */
        byte BIT12       :1;                                       /* Break Address Register Bit 12 */
        byte BIT13       :1;                                       /* Break Address Register Bit 13 */
        byte BIT14       :1;                                       /* Break Address Register Bit 14 */
        byte BIT15       :1;                                       /* Break Address Register Bit 15 */
      } Bits;
    } BRKHSTR;
    #define BRKH                        _BRK.Overlap_STR.BRKHSTR.Byte
    #define BRKH_BIT8                   _BRK.Overlap_STR.BRKHSTR.Bits.BIT8
    #define BRKH_BIT9                   _BRK.Overlap_STR.BRKHSTR.Bits.BIT9
    #define BRKH_BIT10                  _BRK.Overlap_STR.BRKHSTR.Bits.BIT10
    #define BRKH_BIT11                  _BRK.Overlap_STR.BRKHSTR.Bits.BIT11
    #define BRKH_BIT12                  _BRK.Overlap_STR.BRKHSTR.Bits.BIT12
    #define BRKH_BIT13                  _BRK.Overlap_STR.BRKHSTR.Bits.BIT13
    #define BRKH_BIT14                  _BRK.Overlap_STR.BRKHSTR.Bits.BIT14
    #define BRKH_BIT15                  _BRK.Overlap_STR.BRKHSTR.Bits.BIT15
    
    
    #define BRKH_BIT8_MASK              1
    #define BRKH_BIT9_MASK              2
    #define BRKH_BIT10_MASK             4
    #define BRKH_BIT11_MASK             8
    #define BRKH_BIT12_MASK             16
    #define BRKH_BIT13_MASK             32
    #define BRKH_BIT14_MASK             64
    #define BRKH_BIT15_MASK             128


    /*** BRKL - Break Address Register Low; 0x0000FE0A ***/
    union {
      byte Byte;
      struct {
        byte BIT0        :1;                                       /* Break Address Register Bit 0 */
        byte BIT1        :1;                                       /* Break Address Register Bit 1 */
        byte BIT2        :1;                                       /* Break Address Register Bit 2 */
        byte BIT3        :1;                                       /* Break Address Register Bit 3 */
        byte BIT4        :1;                                       /* Break Address Register Bit 4 */
        byte BIT5        :1;                                       /* Break Address Register Bit 5 */
        byte BIT6        :1;                                       /* Break Address Register Bit 6 */
        byte BIT7        :1;                                       /* Break Address Register Bit 7 */
      } Bits;
    } BRKLSTR;
    #define BRKL                        _BRK.Overlap_STR.BRKLSTR.Byte
    #define BRKL_BIT0                   _BRK.Overlap_STR.BRKLSTR.Bits.BIT0
    #define BRKL_BIT1                   _BRK.Overlap_STR.BRKLSTR.Bits.BIT1
    #define BRKL_BIT2                   _BRK.Overlap_STR.BRKLSTR.Bits.BIT2
    #define BRKL_BIT3                   _BRK.Overlap_STR.BRKLSTR.Bits.BIT3
    #define BRKL_BIT4                   _BRK.Overlap_STR.BRKLSTR.Bits.BIT4
    #define BRKL_BIT5                   _BRK.Overlap_STR.BRKLSTR.Bits.BIT5
    #define BRKL_BIT6                   _BRK.Overlap_STR.BRKLSTR.Bits.BIT6
    #define BRKL_BIT7                   _BRK.Overlap_STR.BRKLSTR.Bits.BIT7
    
    
    #define BRKL_BIT0_MASK              1
    #define BRKL_BIT1_MASK              2
    #define BRKL_BIT2_MASK              4
    #define BRKL_BIT3_MASK              8
    #define BRKL_BIT4_MASK              16
    #define BRKL_BIT5_MASK              32
    #define BRKL_BIT6_MASK              64
    #define BRKL_BIT7_MASK              128

  } Overlap_STR;

} BRKSTR;
extern volatile BRKSTR _BRK @0x0000FE09;
#define BRK                             _BRK.Word



/*** BRKSCR - Break Status and Control Register; 0x0000FE0B ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte BRKA        :1;                                       /* Break Active Bit */
    byte BRKE        :1;                                       /* Break Enable Bit */
  } Bits;
} BRKSCRSTR;
extern volatile BRKSCRSTR _BRKSCR @0x0000FE0B;
#define BRKSCR                          _BRKSCR.Byte
#define BRKSCR_BRKA                     _BRKSCR.Bits.BRKA
#define BRKSCR_BRKE                     _BRKSCR.Bits.BRKE

#define BRKSCR_BRKA_MASK                64
#define BRKSCR_BRKE_MASK                128


/*** LVISR - LVI Status Register; 0x0000FE0C ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte             :1; 
    byte LVIOUT      :1;                                       /* LVI Output Bit */
  } Bits;
} LVISRSTR;
extern volatile LVISRSTR _LVISR @0x0000FE0C;
#define LVISR                           _LVISR.Byte
#define LVISR_LVIOUT                    _LVISR.Bits.LVIOUT

#define LVISR_LVIOUT_MASK               128


/*** FLBPR - FLASH Block Protect Register; 0x0000FFBE ***/
typedef union {
  byte Byte;
  struct {
    byte             :1; 
    byte BPR1        :1;                                       /* Block Protect Register Bit 1 */
    byte BPR2        :1;                                       /* Block Protect Register Bit 2 */
    byte BPR3        :1;                                       /* Block Protect Register Bit 3 */
    byte BPR4        :1;                                       /* Block Protect Register Bit 4 */
    byte BPR5        :1;                                       /* Block Protect Register Bit 5 */
    byte BPR6        :1;                                       /* Block Protect Register Bit 6 */
    byte BPR7        :1;                                       /* Block Protect Register Bit 7 */
  } Bits;
  struct {
    byte         :1;
    byte grpBPR_1 :7;
  } MergedBits;
} FLBPRSTR;
extern volatile FLBPRSTR _FLBPR @0x0000FFBE;
#define FLBPR                           _FLBPR.Byte
#define FLBPR_BPR1                      _FLBPR.Bits.BPR1
#define FLBPR_BPR2                      _FLBPR.Bits.BPR2
#define FLBPR_BPR3                      _FLBPR.Bits.BPR3
#define FLBPR_BPR4                      _FLBPR.Bits.BPR4
#define FLBPR_BPR5                      _FLBPR.Bits.BPR5
#define FLBPR_BPR6                      _FLBPR.Bits.BPR6
#define FLBPR_BPR7                      _FLBPR.Bits.BPR7
#define FLBPR_BPR_1                     _FLBPR.MergedBits.grpBPR_1
#define FLBPR_BPR                       FLBPR_BPR_1

#define FLBPR_BPR1_MASK                 2
#define FLBPR_BPR2_MASK                 4
#define FLBPR_BPR3_MASK                 8
#define FLBPR_BPR4_MASK                 16
#define FLBPR_BPR5_MASK                 32
#define FLBPR_BPR6_MASK                 64
#define FLBPR_BPR7_MASK                 128
#define FLBPR_BPR_1_MASK                254
#define FLBPR_BPR_1_BITNUM              1


/*** Optional - Internal Oscillator Trim; 0x0000FFC0 ***/
typedef union {
  byte Byte;
  struct {
    byte TRIM0       :1;                                       /* ICG Trim Factor Bit 0 */
    byte TRIM1       :1;                                       /* ICG Trim Factor Bit 1 */
    byte TRIM2       :1;                                       /* ICG Trim Factor Bit 2 */
    byte TRIM3       :1;                                       /* ICG Trim Factor Bit 3 */
    byte TRIM4       :1;                                       /* ICG Trim Factor Bit 4 */
    byte TRIM5       :1;                                       /* ICG Trim Factor Bit 5 */
    byte TRIM6       :1;                                       /* ICG Trim Factor Bit 6 */
    byte TRIM7       :1;                                       /* ICG Trim Factor Bit 7 */
  } Bits;
} OptionalSTR;
extern volatile OptionalSTR _Optional @0x0000FFC0;
#define Optional                        _Optional.Byte
#define Optional_TRIM0                  _Optional.Bits.TRIM0
#define Optional_TRIM1                  _Optional.Bits.TRIM1
#define Optional_TRIM2                  _Optional.Bits.TRIM2
#define Optional_TRIM3                  _Optional.Bits.TRIM3
#define Optional_TRIM4                  _Optional.Bits.TRIM4
#define Optional_TRIM5                  _Optional.Bits.TRIM5
#define Optional_TRIM6                  _Optional.Bits.TRIM6
#define Optional_TRIM7                  _Optional.Bits.TRIM7

#define Optional_TRIM0_MASK             1
#define Optional_TRIM1_MASK             2
#define Optional_TRIM2_MASK             4
#define Optional_TRIM3_MASK             8
#define Optional_TRIM4_MASK             16
#define Optional_TRIM5_MASK             32
#define Optional_TRIM6_MASK             64
#define Optional_TRIM7_MASK             128


/*** COPCTL - COP Control Register; 0x0000FFFF ***/
typedef union {
  byte Byte;
  struct {
    byte BIT0        :1;                                       /* Bit 0 */
    byte BIT1        :1;                                       /* Bit 1 */
    byte BIT2        :1;                                       /* Bit 2 */
    byte BIT3        :1;                                       /* Bit 3 */
    byte BIT4        :1;                                       /* Bit 4 */
    byte BIT5        :1;                                       /* Bit 5 */
    byte BIT6        :1;                                       /* Bit 6 */
    byte BIT7        :1;                                       /* Bit 7 */
  } Bits;
} COPCTLSTR;
extern volatile COPCTLSTR _COPCTL @0x0000FFFF;
#define COPCTL                          _COPCTL.Byte
#define COPCTL_BIT0                     _COPCTL.Bits.BIT0
#define COPCTL_BIT1                     _COPCTL.Bits.BIT1
#define COPCTL_BIT2                     _COPCTL.Bits.BIT2
#define COPCTL_BIT3                     _COPCTL.Bits.BIT3
#define COPCTL_BIT4                     _COPCTL.Bits.BIT4
#define COPCTL_BIT5                     _COPCTL.Bits.BIT5
#define COPCTL_BIT6                     _COPCTL.Bits.BIT6
#define COPCTL_BIT7                     _COPCTL.Bits.BIT7

#define COPCTL_BIT0_MASK                1
#define COPCTL_BIT1_MASK                2
#define COPCTL_BIT2_MASK                4
#define COPCTL_BIT3_MASK                8
#define COPCTL_BIT4_MASK                16
#define COPCTL_BIT5_MASK                32
#define COPCTL_BIT6_MASK                64
#define COPCTL_BIT7_MASK                128


/* ---------------------------------------------------------------------------------------------------
Exceptions in bit names of timer status and control registers (TASC, TSC, TBSC) for every channel
due to backward compatibility with HC08 AZx versions  */
#define TSC0_CHxMAX _TSC0.Bits.CH0MAX
#define TSC0_TOVx _TSC0.Bits.TOV0
#define TSC0_ELSxA _TSC0.Bits.ELS0A
#define TSC0_ELSxB _TSC0.Bits.ELS0B
#define TSC0_MSxA _TSC0.Bits.MS0A
#define TSC0_MSxB _TSC0.Bits.MS0B
#define TSC0_CHxIE _TSC0.Bits.CH0IE
#define TSC0_CHxF _TSC0.Bits.CH0F

#define TSC1_CHxMAX _TSC1.Bits.CH1MAX
#define TSC1_TOVx _TSC1.Bits.TOV1
#define TSC1_ELSxA _TSC1.Bits.ELS1A
#define TSC1_ELSxB _TSC1.Bits.ELS1B
#define TSC1_MSxA _TSC1.Bits.MS1A
#define TSC1_CHxIE _TSC1.Bits.CH1IE
#define TSC1_CHxF _TSC1.Bits.CH1F




#ifndef __RESET_WATCHDOG_MACRO
#define __RESET_WATCHDOG_MACRO
  /* Watchdog reset macro */
#ifdef _lint
  #define __RESET_WATCHDOG()  /* empty */
#else
  #define __RESET_WATCHDOG() {asm sta COPCTL;}  /* Just write a byte to feed the dog */
#endif
#endif /* __RESET_WATCHDOG_MACRO */

#endif

/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 03.51 for 
**     the Motorola HC08 series of microcontrollers.
**
** ###################################################################
*/

