/** ###################################################################
**     Filename  : Events.H
**     Project   : oscillateur
**     Processor : MC68HC908QT1CP
**     Beantype  : Events
**     Version   : Driver 01.03
**     Compiler  : Metrowerks HC08 C Compiler
**     Date/Time : 08/02/2005, 18:55
**     Abstract  :
**         This is user's event module.
**         Put your event handler code here.
**     Settings  :
**     Contents  :
**         Bouton_OnInterrupt - void Bouton_OnInterrupt(void);
**         Cpu_OnSwINT        - void Cpu_OnSwINT(void);
**
**     (c) Copyright UNIS, spol. s r.o. 1997-2004
**     UNIS, spol. s r.o.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/

#ifndef __Events_H
#define __Events_H
/* MODULE Events */

#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "Bip.h"
#include "Bouton.h"
#include "Led.h"

/*
** ===================================================================
**     Event       :  Bouton_OnInterrupt (module Events)
**
**     From bean   :  Bouton [ExtInt]
**     Description :
**         This event is called when the active signal edge/level
**         occurs.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
void Bouton_OnInterrupt(void);

void Cpu_OnSwINT(void);
/*
** ===================================================================
**     Event       :  Cpu_OnSwINT (module Events)
**
**     From bean   :  Cpu [MC68HC908QT1]
**     Description :
**         This software event is called after software reset.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/


void Bip_OnFalling(void);
/*
** ===================================================================
**     Event       :  Bip_OnFalling (module Events)
**
**     From bean   :  Bip [TimerOut]
**     Description :
**         This event is called at falling edge of the output signal.
**         (only when the bean is enabled - "Enable" and the events
**         are enabled - "EnableEvent").
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

/* END Events */
#endif /* __Events_H*/

/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 03.51 for 
**     the Motorola HC08 series of microcontrollers.
**
** ###################################################################
*/
