/** ###################################################################
**     Filename  : Events.C
**     Project   : oscillateur
**     Processor : MC68HC908QT1CP
**     Beantype  : Events
**     Version   : Driver 01.03
**     Compiler  : Metrowerks HC08 C Compiler
**     Date/Time : 08/02/2005, 18:55
**     Abstract  :
**         This is user's event module.
**         Put your event handler code here.
**     Settings  :
**     Contents  :
**         Bouton_OnInterrupt - void Bouton_OnInterrupt(void);
**         Cpu_OnSwINT        - void Cpu_OnSwINT(void);
**
**     (c) Copyright UNIS, spol. s r.o. 1997-2004
**     UNIS, spol. s r.o.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/
/* MODULE Events */

#pragma MESSAGE DISABLE C1420 /* WARNING C1420: Result of function-call is ignored */


#include "Cpu.h"
#include "Events.h"

/*
** ===================================================================
**     Event       :  Bouton_OnInterrupt (module Events)
**
**     From bean   :  Bouton [ExtInt]
**     Description :
**         This event is called when the active signal edge/level
**         occurs.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
void Bouton_OnInterrupt(void)
{
  /* place your Bouton interrupt procedure body here*/
  if (Led_GetVal())	   //ligne  1 donc Led teinte
    {
        Bip_Enable();   //on valide la gnration du signal carr
        Led_ClrVal();   // on met  0 la ligne de la Led pour l'allumer
    }
    else
    {
         Bip_Disable(); // on stoppe la gnration du signal carr
         Led_SetVal(); // on met  1 la ligne de la Led pour l'teindre
    }
    
}

/*
** ===================================================================
**     Event       :  Cpu_OnSwINT (module Events)
**
**     From bean   :  Cpu [MC68HC908QT1]
**     Description :
**         This software event is called after software reset.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
void Cpu_OnSwINT(void)
{
  /* Write your code here ... */
}

/*
** ===================================================================
**     Event       :  Bip_OnFalling (module Events)
**
**     From bean   :  Bip [TimerOut]
**     Description :
**         This event is called at falling edge of the output signal.
**         (only when the bean is enabled - "Enable" and the events
**         are enabled - "EnableEvent").
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
void Bip_OnFalling(void)
{
  /* Write your code here ... */
}

/* END Events */

/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 03.51 for 
**     the Motorola HC08 series of microcontrollers.
**
** ###################################################################
*/
