/** ###################################################################
**     THIS BEAN MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : Cpu.C
**     Project   : oscillateur
**     Processor : MC68HC908QT1CP
**     Beantype  : MC68HC908QT1
**     Version   : Bean 01.008, Driver 01.26.01, CPU db: 2.87.099
**     Datasheet : MC68HC908QY4/D Rev 3.0 1/2004
**     Compiler  : Metrowerks HC08 C Compiler
**     Date/Time : 08/02/2005, 23:16
**     Abstract  :
**         This bean "MC68HC908QT1" implements properties, methods,
**         and events of the CPU.
**     Settings  :
**         Clock setting
**             Internal clock      : 12800 kHz
**             Initialization interrupt priority : 1
**             LVI module          : no
**
**         Speed modes
**             High speed clock    : Internal Clock
**             Internal bus clock  : 3.2 MHz
**             Low speed mode      : Disabled
**             Slow speed mode     : Disabled
**     Contents  :
**         GetSpeedMode - byte Cpu_GetSpeedMode(void);
**         EnableInt    - void Cpu_EnableInt(void);
**         DisableInt   - void Cpu_DisableInt(void);
**
**     (c) Copyright UNIS, spol. s r.o. 1997-2004
**     UNIS, spol. s r.o.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/

/* MODULE Cpu. */

#include "Bip.h"
#include "Bouton.h"
#include "Led.h"
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "Events.h"
#include "Cpu.h"



/* Global variables */
volatile byte CCR_reg;                 /* Current CCR register */
byte CpuMode = HIGH_SPEED;             /* Current speed mode */


/*
** ===================================================================
**     Method      :  Cpu_Interrupt (bean MC68HC908QT1)
**
**     Description :
**         This method is internal. It is used by Processor Expert
**         only.
** ===================================================================
*/
__interrupt void Cpu_Interrupt(void)
{
}

/*
** ===================================================================
**     Method      :  Cpu_SWIInterrupt (bean MC68HC908QT1)
**
**     Description :
**         This method is internal. It is used by Processor Expert
**         only.
** ===================================================================
*/
__interrupt void Cpu_SWIInterrupt(void)
{
  Cpu_OnSwINT();                       /* Invoke user event */
}

/*
** ===================================================================
**     Method      :  Cpu_DisableInt (bean MC68HC908QT1)
**
**     Description :
**         Disable maskable interrupts
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void Cpu_DisableInt(void)

**      This method is implemented as macro in the header module. **
*/

/*
** ===================================================================
**     Method      :  Cpu_EnableInt (bean MC68HC908QT1)
**
**     Description :
**         Enable maskable interrupts
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void Cpu_EnableInt(void)

**      This method is implemented as macro in the header module. **
*/

/*
** ===================================================================
**     Method      :  Cpu_GetSpeedMode (bean MC68HC908QT1)
**
**     Description :
**         Get current speed mode
**     Parameters  : None
**     Returns     :
**         ---             - Speed mode (HIGH_SPEED, LOW_SPEED,
**                           SLOW_SPEED)
** ===================================================================
*/
byte Cpu_GetSpeedMode(void)
{
  return CpuMode;                      /* Result the actual cpu mode */
}



/*
** ===================================================================
**     Method      :  _EntryPoint (bean MC68HC908QT1)
**
**     Description :
**         This method is internal. It is used by Processor Expert
**         only.
** ===================================================================
*/
extern void _Startup(void);            /* Forward declaration of external startup function declared in file Start12.c */
#pragma NO_FRAME
#pragma NO_EXIT
void _EntryPoint(void)
{
  /*** ### MC68HC908QT1 "Cpu" init code ... ***/
  /*** PE initialization code after reset ***/
  /* System clock initialization */
  /* CONFIG1: COPRS=0,LVISTOP=0,LVIRSTD=0,LVIPWRD=1,LVI5OR3=0,SSREC=0,STOP=0,COPD=1 */
  CONFIG1 = 17;                        /* Set the CONFIG1 register */
  /* CONFIG2: IRQPUD=0,IRQEN=1,??=0,OSCOPT1=0,OSCOPT0=0,??=0,??=0,RSTEN=0 */
  CONFIG2 = 64;                        /* Set the CONFIG2 register */
  OSCSTAT = 0;                         /* Disable the external oscillator */
  OSCTRIM = *(byte*)0xFFC0;            /* Initialize OSCTRIM register from a non volatile memory */
  /*** End of PE initialization code after reset ***/

  __asm   jmp _Startup ;               /* Jump to C startup code */

}

/*
** ===================================================================
**     Method      :  PE_low_level_init (bean MC68HC908QT1)
**
**     Description :
**         This method is internal. It is used by Processor Expert
**         only.
** ===================================================================
*/
void PE_low_level_init(void)
{
  /* Common initialization of the CPU registers */
  /* PTA: PTA1=1 */
  setReg8Bits(PTA, 2);                  
  /* DDRA: DDRA1=1,DDRA0=0 */
  clrSetReg8Bits(DDRA, 1, 2);           
  /* PTAPUE: PTAPUE1=0 */
  clrReg8Bits(PTAPUE, 2);               
  /* ### MC68HC908QT1 "Cpu" init code ... */
  /* ### TimerOut "Bip" init code ... */
  Bip_Init();
  /* ### External interrupt "Bouton" init code ... */
  INTSCR_MODE = 0;                     /* Set falling edge */
  INTSCR_IMASK = 1;
  INTSCR_ACK = 1;
  INTSCR_IMASK = 0;
  /* ### BitIO "Led" init code ... */
  __EI();                              /* Enable interrupts */
}

/* END Cpu. */

/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 03.51 for 
**     the Motorola HC08 series of microcontrollers.
**
** ###################################################################
*/
