/** ###################################################################
**     THIS BEAN MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : Bip.C
**     Project   : oscillateur
**     Processor : MC68HC908QT1CP
**     Beantype  : TimerOut
**     Version   : Bean 02.088, Driver 01.21, CPU db: 2.87.099
**     Compiler  : Metrowerks HC08 C Compiler
**     Date/Time : 23/05/2005, 19:58
**     Abstract  :
**         This bean implements a periodic signal generator 1:1 (Flip-Flop Output).
**         The signal alternates the "0" and "1" output values in exactly
**         regular intervals; that is why the time length of the "0" part
**         of one pulse is equal to the "1" part of one pulse.
**     Settings  :
**         Used output pin             : 
**             ----------------------------------------------------
**                Number (on package)  |    Name
**             ----------------------------------------------------
**                       7             |  PTA0_TCH0_KBI0
**             ----------------------------------------------------
**
**         Timer name                  : TIM (16-bit)
**         Compare name                : TIM0
**           Counter shared            : No
**           Output compare            : unbuffered
**
**         High speed mode
**             Prescaler               : divide-by-1
**             Clock                   : 3200000 Hz
**           Pulse width
**             Xtal ticks              : 6400
**             microseconds            : 500
**             seconds (real)          : 0.0005000
**             Hz                      : 2000
**             kHz                     : 2
**
**         Runtime setting             : none
**
**         Initialization:
**              Output level           : low
**              Timer                  : Disabled
**              Events                 : Enabled
**
**         Timer registers
**              Counter                : TCNT      [33]
**              Mode                   : TSC       [32]
**              Run                    : TSC       [32]
**              Prescaler              : TSC       [32]
**
**         Compare registers
**              Compare                : TCH0      [38]
**
**         Flip-flop registers
**              Mode                   : TSC0      [37]
**     Contents  :
**         Enable  - byte Bip_Enable(void);
**         Disable - byte Bip_Disable(void);
**
**     (c) Copyright UNIS, spol. s r.o. 1997-2004
**     UNIS, spol. s r.o.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/


/* MODULE Bip. */

#include "Events.h"
#include "PE_Error.h"
#include "Bip.h"

#pragma MESSAGE DISABLE C2705          /* WARNING C2705: Possible loss of data */
#pragma MESSAGE DISABLE C5919          /* WARNING C5919: Conversion of floating to unsigned integral */

static bool EnUser;                    /* Enable/Disable device by user */
static byte portbit;

/*
** ===================================================================
**     Method      :  SetCV (bean TimerOut)
**
**     Description :
**         This method is internal. It is used by Processor Expert
**         only.
** ===================================================================
*/
static void SetCV(word Val)
{
  TCH0H = (*(TWREG*)&Val).b.high;      /* Store given value to the compare register */
  TMODH = (*(TWREG*)&Val).b.high;      /* Store given value to the modulo register */
  TCH0L = (*(TWREG*)&Val).b.low;
  TMODL = (*(TWREG*)&Val).b.low;
}

/*
** ===================================================================
**     Method      :  SetPV (bean TimerOut)
**
**     Description :
**         This method is internal. It is used by Processor Expert
**         only.
** ===================================================================
*/
static void SetPV(byte Val)
{
  TSC_PS = Val;                        /* Store given value to the prescaler */
  TSC_TRST = 1;                        /* Reset counter */
}

/*
** ===================================================================
**     Method      :  HWEnDi (bean TimerOut)
**
**     Description :
**         This method is internal. It is used by Processor Expert
**         only.
** ===================================================================
*/
static void HWEnDi(void)
{
  if (EnUser) {                        /* Enable device? */
    portbit = 0;
    TSC_TSTOP = 0;                     /* Run counter */
  }
  else {                               /* Disable device? */
    TSC_TSTOP = 1;                     /* Stop counter */
    TSC_TRST = 1;                      /* Reset counter */
    /* TSC0: CH0F=0,CH0IE=0,MS0B=0,MS0A=1,ELS0B=0,ELS0A=0,TOV0=0,CH0MAX=0 */
    TSC0 = 16;                         /* Preset low output level */
    /* TSC0: CH0F=0,CH0IE=1,MS0B=0,MS0A=1,ELS0B=0,ELS0A=1,TOV0=0,CH0MAX=0 */
    TSC0 = 84;                         /* Restore initial output signal level */
  }
}

/*
** ===================================================================
**     Method      :  Bip_Enable (bean TimerOut)
**
**     Description :
**         Enables the bean - it starts the signal generation. Events
**         may be generated ("DisableEvent"/"EnableEvent").
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte Bip_Enable(void)
{
  if (!EnUser) {                       /* Is the device disabled by user? */
    EnUser = TRUE;                     /* If yes then set the flag "device enabled" */
    HWEnDi();                          /* Enable the device */
  }
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  Bip_Disable (bean TimerOut)
**
**     Description :
**         Disables the timer - it stops signal generation and events
**         calling. When the timer is disabled, it is possible to
**         call methods "ClrValue" and "SetValue".
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte Bip_Disable(void)
{
  if (EnUser) {                        /* Is the device enabled by user? */
    EnUser = FALSE;                    /* If yes then set the flag "device disabled" */
    HWEnDi();                          /* Disable the device */
  }
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  Bip_Init (bean TimerOut)
**
**     Description :
**         This method is internal. It is used by Processor Expert
**         only.
** ===================================================================
*/
void Bip_Init(void)
{
  /* TSC: TOF=0,TOIE=0,TSTOP=1,TRST=1,??=0,PS2=0,PS1=0,PS0=0 */
  TSC = 48;                            /* Set up output compare mode */
  /* TSC0: CH0F=0,CH0IE=0,MS0B=0,MS0A=1,ELS0B=0,ELS0A=0,TOV0=0,CH0MAX=0 */
  TSC0 = 16;                           /* Set output signal level to low */
  /* TSC0: CH0F=0,CH0IE=1,MS0B=0,MS0A=1,ELS0B=0,ELS0A=1,TOV0=0,CH0MAX=0 */
  TSC0 = 84;                           /* Enable interrupt */
  EnUser = FALSE;                      /* Disable device */
  SetCV(1600);                         /* Store appropriate value to the compare register according to the selected high speed CPU mode */
  SetPV(0);                            /* Set prescaler register according to the selected high speed CPU mode */
  HWEnDi();                            /* Enable/disable device according to status flags */
}

/*
** ===================================================================
**     Method      :  Bip_Interrupt (bean TimerOut)
**
**     Description :
**         This method is internal. It is used by Processor Expert
**         only.
** ===================================================================
*/
__interrupt void Bip_Interrupt(void)
{
  TSC0_CHxF = 0;                       /* Reset interrupt request flag */
  portbit = ~portbit;
  if (portbit == 0) {                  /* Is the pin output level low? */
    Bip_OnFalling();                   /* Invoke user event */
  }
}

/* END Bip. */

/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 03.51 for 
**     the Motorola HC08 series of microcontrollers.
**
** ###################################################################
*/
