;=============================================================================
; simple programme de dmonstration dsPic et WINPIC
; clignotement LED connecte sur D0
; (programme microchip simplifi)
;=============================================================================
	.equ __30F2010, 1
	.include "p30f2010.inc"
;------------------------------------------------------------------------------
;Global Declarations
	.global __reset ; tiquette de la premire ligne du programme

;------------------------------------------------------------------------------
;Configuration bits ;  
	config __FOSC, CSW_FSCM_OFF & FRC
	config __FWDT, WDT_OFF
	config __FBORPOR, PBOR_OFF & BORV_27 & PWRT_16 & MCLR_EN
	config __FGS, CODE_PROT_OFF

;le programme
.text ;dbut de la section

;Initialize Stack Pointer and Limit Register
__reset: mov #__SP_init, W15 ;Initialize the Stack Pointer register
	mov #__SPLIM_init, W0 ;Get address at the end of stack space
	mov W0, SPLIM ;Load the Stack Pointer Limit register
	nop ;Add NOP to follow SPLIM initialization

;Initialize LED output on PORTD bit 0
	mov #0xfffe, W0 ;Initialize LED pin data to off state
	mov W0, LATD
	mov #0xfffe, W0 ;Set LED pin as output
	mov W0, TRISD
	bset LATD, #0 ;Turn LED on

;Initialize Timer1 for 2 second period
	clr T1CON ;Turn off Timer1 by clearing control register
	clr TMR1 ;Start Timer1 at zero
	mov #0x1E84,W0 ;Get period register value for 1 second
	mov W0, PR1 ;Load Timer1 period register
	mov #0x8030,W0 ;Get Timer1 settings (1:256 prescaler)
	mov W0, T1CON ;Load Timer1 settings into control register

;Loop while waiting for a Timer1 match and toggle LED1 when it happens
MainLoop: btss IFS0, #T1IF ;Check if Timer1 interrupt flag is set
	bra MainLoop ;Loop back until set
	bclr IFS0, #T1IF ;Clear Timer1 interrupt flag
	btg LATD, #0 ;Toggle LED
	bra MainLoop ;Loop back
;=======================================================

	.end  ; fin du programme
