		PROCESSOR	PIC16F84A
		INCLUDE		"P16F84A.INC"
		RADIX		HEX
		__CONFIG 	_CP_OFF & _WDT_OFF & _PWRTE_ON & _XT_OSC

;  Quartz de 4 Mhz   ***********************************************

			cblock	0x10

TEMP1			; compteur temporaire pour les boucles
TEMP2			; compteur temporaire pour les boucles

TEMP3			; registre temporaire pour affichage
TEMP4			; registre temporaire pour affichage

btmp			; registre temporaire pour conversion hex

Stemp			; registres de sauvegarde pendant
Wtemp			; interruptions (W et STATUS)

ADCCtr
ADCresult

ADCpH4			; valeur ADC d'talonnage (stockage eeprom)
ADCpH7			; valeur ADC d'talonnage (stockage eeprom)

				; pH = ADCresult.(AN/AD)+BN  c'est  dire y= ax+b
AN:2			; AN = 700-400 = 300
AD:2			; AD = ADCpH4-ADCpH7 (ex 128-160 = -32)
BN:2			; |BN| = (AN/AD).ADCpH4-700 (ex = 500) = -BN  
PH:2			; pH = x.(AN/AD)-|BN|

LCD_TEMP		; registre temporaire pour traitement LCD
			endc

			cblock	0x30
dixmil
mille
cent
dix
un
val1:2
val2:2
count
reste:2
result:2
			endc		

BPmenu		EQU		0			; RB0
BPselect	EQU		1			; RB1

RS			EQU 	2			; RB2
E			EQU		3			; RB3
LCD_PORT	EQU		PORTB
DEBUTLIGNE1	EQU	0x80
DEBUTLIGNE2	EQU	0xC0

;************************************************************************************
			ORG		00			; vecteur de reset
			GOTO	init_prog

			ORG		04			; vecteur d'interruption
			MOVWF	Wtemp		; push
			SWAPF	STATUS, w
			MOVWF	Stemp		

fin_interr	SWAPF	Stemp, w	; pop
			MOVWF	STATUS
			SWAPF	Wtemp, f
			SWAPF	Wtemp, w
			BCF		INTCON, T0IF	; clear flag Inter
			RETFIE

init_prog	; dbut du programme
			BSF		STATUS, RP0	; bank1
			MOVLW	b'11111100'
			MOVWF	TRISA		; RA0 et RA1 en sortie, le reste en entre (dont RA2)
			MOVLW	b'00000011'
			MOVWF	TRISB		; RB0 et RB1 en entre, le reste en sortie
			BCF		STATUS, RP0	; retour bank0
			CLRF	PORTB
			CALL	LCD_INIT
			CALL 	initpHADC		; rcupre les valeurs ADC d'talonnage depuis l'eeprom
			CALL 	calculAB
;****************************************************************
main		CALL	delai250ms		; pause 250ms
			MOVLW	DEBUTLIGNE1
			CALL	LCD_CMD
			MOVLW	LOW msg_mes
			CALL	AFFICHE			; "MESURE"
			MOVLW	LOW msg_ph
			CALL 	AFFICHE			; "MESURE PH= "
			CALL 	ReadADC			; rcupre x
			CALL	calculpH		; pH = val1
			CALL	bcd5			; affiche la valeur
			MOVLW	DEBUTLIGNE2
			CALL	LCD_CMD
			MOVLW	LOW msg_menu
			CALL	AFFICHE
			BTFSC	PORTB, BPmenu	; si BPmenu=0 => le bouton est appuy
			GOTO	main			
; **********************************  menu suivant
			MOVLW	0x01			
			CALL	LCD_CMD			; efface l'cran
			CALL	delai25ms		; antirebond
reb_menu	BTFSS	PORTB, BPmenu	; menu / antirebond
			GOTO	reb_menu
			CALL	delai25ms		; antirebond
			MOVLW	DEBUTLIGNE1
			CALL	LCD_CMD
			MOVLW	LOW msg_ok
			CALL	AFFICHE			; "OK ?"
			MOVLW	DEBUTLIGNE2
			CALL	LCD_CMD
			MOVLW	LOW msg_init
			CALL 	AFFICHE			; "REINIT" propose reinitialisation
attent1		BTFSS	PORTB, BPmenu
			GOTO	reb_etal		; si bouton menu appuy => afficher choix suivant
			BTFSS	PORTB, BPselect	
			GOTO	reinit			; si bouton ok appuy => rinitialiser
			GOTO	attent1
; **********************************  menu suivant
reb_etal	MOVLW	0x01			
			CALL	LCD_CMD			; efface l'cran
			CALL	delai25ms		; antirebond	
reb_menu2	BTFSS	PORTB, BPmenu	; menu / antirebond
			GOTO	reb_menu2
			CALL	delai25ms		; antirebond
			MOVLW	DEBUTLIGNE1
			CALL	LCD_CMD
			MOVLW	LOW msg_ok
			CALL	AFFICHE			; "OK ?"
			MOVLW	DEBUTLIGNE2
			CALL	LCD_CMD
			MOVLW	LOW msg_etal
			CALL 	AFFICHE			; "ETALON" propose talonnage
attent2		BTFSS	PORTB, BPmenu
			GOTO	reb_retour		; si bouton menu appuy => vers main
			BTFSS	PORTB, BPselect	
			GOTO	etalon			; si bouton ok appuy => talonner
			GOTO	attent2
; **********************************  menu suivant (on reboucle)
reb_retour	MOVLW	0x01			
			CALL	LCD_CMD			; efface l'cran
			CALL	delai25ms		; antirebond	
reb_menu3	BTFSS	PORTB, BPmenu	; menu / antirebond
			GOTO	reb_menu3
			CALL	delai25ms
			GOTO	main

calculpH	MOVF	ADCresult, w
			MOVWF	val1+1
			CLRF	val1			; val1 (16bits) = ADCresult = x
			MOVF	AN, w
			MOVWF	val2
			MOVF	AN+1, w
			MOVWF	val2+1			; val2 (16bits) = AN
			CALL	mult16			; val1 = x . AN
			MOVF	AD+1, w
			MOVWF	val2+1
			CLRF	AD				; val2 (16bits) = AD
			CALL 	div16			; val1 = x.AN/AD
			MOVF	val1, w
			MOVWF	val2
			MOVF	val1+1, w
			MOVWF	val2+1			; val2 = x.AN/AD
			MOVF	BN, w
			MOVWF	val1
			MOVF	BN+1, w
			MOVWF	val1+1			; val1 (16bits) = BN
			CALL	sub16			; val1 = BN- x.AN/AD
			RETURN

; ROUTINES DE PILOTAGE DE L'ECRAN LCD*****************************************

LCD_CMD		MOVWF	LCD_TEMP		;envoie commande 2x4 bits - On met W dans LCD_TEMP
			ANDLW	0xF0			; masquage des bit de poids faible
			MOVWF	PORTB			; on envoit a l'afficheur / RS reste  0
			CALL	enable
			SWAPF	LCD_TEMP, w		; passage des bits de poids faibles en poids fort
			ANDLW	0xF0			; masquage des bit de poids faible		
			MOVWF	PORTB			; on envoit a l'afficheur / RS reste  0
			CALL	enable
			RETURN

LCD_CAR		MOVWF	LCD_TEMP		; envoie caractre 2x4bits - On met W dans LCD_TEMP
			ANDLW	0xF0			; masquage des bit de poids faible
			MOVWF	PORTB			; on envoit a l'afficheur
			BSF		LCD_PORT, RS	; mise  1 de RS
			CALL	enable
			SWAPF	LCD_TEMP, w		; passage des bits de poids faibles en poids fort
			ANDLW	0xF0			; masquage des bit de poids faible
			MOVWF	PORTB			; on envoit a l'afficheur
			BSF		LCD_PORT, RS	; mise  1 de RS		
			CALL	enable	
			RETURN					; fini
	
LCD_INIT	MOVLW	0x20			; initialisation afficheur mode 4 bits			
			MOVWF	PORTB
			CALL	enable
			CALL 	delai1600
			MOVLW	0x28			; mode 4 bits / 2l / 5x7pts poids fort			
			CALL	LCD_CMD			; transfert en 2 temps
			CALL	delai40
			MOVLW	0x0C			; display on
			CALL	LCD_CMD			; transfert en 2 temps
			CALL	delai40
			MOVLW	0x01			; clear display
			CALL	LCD_CMD			; transfert en 2 temps
			CALL	delai40
			MOVLW	0x06			; mode set increment / affich vers la droite
			CALL	LCD_CMD			; transfert en 2 temps
			CALL	delai40
			RETURN

delai1600	MOVLW	0xFF
			MOVWF	TEMP1
			MOVLW	0x03
			MOVWF	TEMP2
b1600		DECFSZ	TEMP1, f
			GOTO	b1600
			DECFSZ	TEMP2, f
			GOTO	b1600
			RETURN

delai40		MOVLW	0x11			; 40 s (=40-6)/2 = dec17 = 0x11
			MOVWF	TEMP1
b40			DECFSZ	TEMP1, f
			GOTO	b40
			RETURN

			
enable		BSF		LCD_PORT, E
			CALL	delai40
			BCF		LCD_PORT, E
			RETURN

AFFICHE		BCF		STATUS, RP0		; bank 0
			MOVWF	EEADR
boucle		BSF		STATUS, RP0		; bank 1
			BSF		EECON1, RD
			BCF		STATUS, RP0
			MOVF	EEDATA, w		; rcupre la valeur dans W
			BTFSC	STATUS, Z		; si W=0 => Z=1
			RETURN					; si W=0 => fini
			CALL	LCD_CAR
			INCF	EEADR, f
			GOTO	boucle	

;	Routines de calculs mathmatiques V1.1
;
;	call add16	: Addition 16 bits		: val1 = val1 + val2
;	call sub16  : Soustraction 16 bits		: val1 = val1 - val2
;	call mult16	: Multiplication 16 bits	: val1 = val1 * val2
;	call div16	: Division 16 bits		: val1 = val1 / val2       ( reste )
;
;	variables a definir dans le programme principal:
;
;	count			; variable  8 bits pour division et multiplication 16 bits
;	reste:2			; variable 16 bits pour division 16 bits
;	val1:2			; variable 16 bits pour calcul 16 bits
;	val2:2			; variable 16 bits pour calcul 16 bits
;	result:2		; variable 16 bits pour calcul 16 bits
;
;	note : les valeurs 16 bits sont stockees HI-LO
;

sub16		movf   val2,w		; soustraction 16 bits
			subwf  val1,f		; val1 = val1 - val2
			movf   val2+1,w
			subwf  val1+1,f
 			btfss  STATUS,C
			decf   val1,f
			return
             
add16		movf   val2,w		; addition 16 bits
			addwf  val1,f		; val1 = val1 + val2
			movf   val2+1,w
			addwf  val1+1,f
			btfsc  STATUS, C
			incf   val1,f
			return

mult16		clrf   result		; multiplication 16 bits
			clrf   result+1		; val1 = val1 * val2
			movlw  .16
			movwf  count
mult161		rrf    val1,f
			rrf    val1+1,f
			btfss  STATUS,C
			goto   mult162
			movf   val2,w
			addwf  result,f
			movf   val2+1,w
			addwf  result+1,f
			btfsc  STATUS,C
			incf   result,f
mult162		bcf    STATUS,C
			rlf    val2+1,f 
			rlf    val2,f
			decfsz count,f
			goto   mult161
			goto   fin16

div16		clrf    reste		; division 16 bits
			clrf    reste+1		; val1 = val1 / val2       ( reste )
			movlw   .16
			movwf   count
div161		rlf     val1+1,f
			rlf     val1,f
			rlf     reste+1,f
			rlf     reste,f
			movf    val2,w
			subwf   reste,W
			btfss   STATUS,Z
			goto    div162
			movf    val2+1,W
			subwf   reste+1,W
div162		btfss   STATUS,C
			goto    div163
			movf    val2+1,W
			subwf   reste+1,f
			movf    val2,W
			btfss   STATUS,C
			incfsz  val2,f
			subwf   reste,f
div163 		rlf     result+1,f
 			rlf     result,f
			DECFSZ  count,f     
			goto    div161
fin16		movf   result,w
			movwf  val1
			movf   result+1,w
			movwf  val1+1
			return

;	V1.01 du 10/03/2001
;	routines de conversion binaire --> BCD 
;
;	call bcd5	: affiche valeur de 16 bits ( contenue dans val1 16bits) en decimal 5 digits --> 00000 a 65535
;	call bcd3	: affiche valeur de  8 bits ( contenue dans w ) en decimal 3 digits --> 000 a 255
;	call hex8	: affiche valeur de  8 bits ( contenue dans w ) en hexadecimal 2 digits --> 00 a FF
;
;	variables a definir dans le programme principal:
;
;				note : les valeurs 16 bits sont stockees HI-LO
;
;	dixmil,mille,cent,dix,un; variable pour convertion binaire --> BCD 16bits

;	val1:2			; variable pour stockage valeur 16 bits
;	val2:2			; variable pour stockage valeur 16 bits
;


bcd5		swapf  val1,w		; affichage octet --> decimal 5 digits ( de 0 a 65535 )
			iorlw  0xf0
			movwf  mille 
			addwf  mille,f 
			addlw  0xE2 
			movwf  cent 
			addlw  0x32 
			movwf  un 
			movf   val1,w 
			andlw  0x0F 
			addwf  cent,f 
			addwf  cent,f 
			addwf  un,f 
			addlw  0xE9 
			movwf  dix 
			addwf  dix,f 
			addwf  dix,f 
			swapf  val1+1,w 
			andlw  0x0F 
			addwf  dix,f 
			addwf  un,f 
			rlf    dix,f 
			rlf    un,f 
			comf   un,f 
			rlf    un,f 
			movf   val1+1,w 
			andlw  0x0F 
			addwf  un,f 
			rlf    mille,f 
			movlw  0x07 
			movwf  dixmil 
      		movlw  0x0A
Lb1: 		addwf  un,f 
			decf   dix,f 
			btfss  STATUS,C
			goto   Lb1 
Lb2:		addwf  dix,f 
			decf   cent,f 
			btfss  STATUS,C
			goto   Lb2 
Lb3:		addwf  cent,f 
			decf   mille,f 
			btfss  STATUS,C
			goto   Lb3 
Lb4:		addwf  mille,f 
      		decf   dixmil,f 
			btfss  STATUS,C
    	    goto   Lb4 
			;movf   dixmil,w		; ici on n'affiche pas les dizaines de milliers
			;addlw  '0'
			;call   LCD_CAR
			movf   mille,w
			addlw  '0'
			call   LCD_CAR
			movf   cent,w
			addlw  '0'
			call	LCD_CAR
			MOVLW	"."
			call	LCD_CAR			; avec un sparateur
			movf   dix,w
			addlw  '0'
			call   LCD_CAR
			movf   un,w
			addlw  '0'
			goto   LCD_CAR

hex8		movwf   btmp		; affichage octet --> hexadecimal 2 digits ( de 00 a FF )
      		swapf   btmp,W
     		andlw   0x0f
  		    addlw   -0x0a
       		btfsc   STATUS,C
        	addlw   0x07
        	addlw   0x3a
			call    LCD_CAR		; affichage nibble poids fort
        	movf    btmp,W
        	andlw   0x0f
        	addlw   -0x0a 
       		btfsc   STATUS, C 
        	addlw   0x07 
        	addlw   0x3a 
			goto    LCD_CAR		; affichage nibble poids faible

;   Port A <> ADC0831 Serial ADC
;   RA0       ADC CS (Output)
;   RA2       ADC Data (Input)
;   RA1       ADC Clock (Output)

ADCCS     equ    0
ADCDAT    equ    2
ADCCLK    equ    1

ReadADC		clrf    ADCresult
			bcf     PORTA,ADCCS    ;Activate /CS line on the ADC to start
			movlw   8              ;Set number of bits to read in = 8 +1 start
			movwf   ADCCtr         ;Load this into the counter register
			bsf     PORTA,ADCCLK   ;Pulse the ADC clock line High then Low to
			nop                    ;  signal the start of a conversion
			bcf     PORTA,ADCCLK
Get_One_Bit		                   ;This is the main loop, should execute 9 times
			bsf     PORTA,ADCCLK   ;Pulse the ADC clock line high then low
			nop                    ;  to get one data bit
			bcf     PORTA,ADCCLK
			bcf     STATUS,C       ;Clear Carry Bit
			btfsc   PORTA,ADCDAT   ;Check the value of the data bit
			bsf     STATUS,C       ;Bit is a one ... set carry bit and rotate in
			rlf     ADCresult, f   ;Shift bits left from carry into ADResult
			decfsz  ADCCtr,f       ;Decrement Bit Counter
			goto    Get_One_Bit    ;Do it 9 times, first bit is a START bit
			bsf     PORTA,ADCCS    ;When done, Disable the ADC
			return                ;All is OK, return with the value

; 
initpHADC	MOVLW 	LOW et_ADCpH7
			CALL	readeprom			
			MOVF	EEDATA, w		; rcupre la valeur dans W
			MOVWF	ADCpH7			; la stocke en RAM 
			MOVLW 	LOW et_ADCpH4
			CALL	readeprom			
			MOVF	EEDATA, w		; rcupre la valeur dans W
			MOVWF	ADCpH4			; la stocke en RAM
			RETURN

calculAB	MOVLW	HIGH (.700-.400)
			MOVWF	AN
			MOVLW	LOW (.700-.400)
			MOVWF	AN+1
			MOVF	ADCpH7, w			; W = ADCpH7 (ex = 128)
			SUBWF	ADCpH4,0		; W = ADCpH4 - ADCpH7 (ex = 128-160)
			MOVWF	AD+1
			CLRF 	AD
			MOVF	AN, w
			MOVWF	val1
			MOVF	AN+1, w
			MOVWF	val1+1			; val1 = AN
			CLRF	val2
			MOVF	ADCpH7, w
			MOVWF	val2+1			; val2 = ADCpH7
			CALL 	mult16			; val1 = AN x ADCpH7
			CLRF	val2
			MOVF	AD+1, w
			MOVWF	val2+1			; val2 = AD
			CALL	div16			; val1 = AN x ADCpH7 / AD
			MOVLW	HIGH .700
			MOVWF	val2
			MOVLW	LOW	.700
			MOVWF	val2+1
			CALL 	add16			; val1 = AN x ADCpH7 / AD + 700
			MOVF	val1, w
			MOVWF	BN
			MOVF	val1+1, w
			MOVWF	BN+1			; stock dans BN
			RETURN					; on a calcul AN, AD et BN

writeprom	BSF		STATUS, RP0		; bank 1
			BCF		INTCON, GIE
			BSF 	EECON1, WREN	; autorise l'criture dans l'eeprom (EEDATA  EEADR)
			MOVLW	0x55			;
			MOVWF	EECON2			;
			MOVLW	0xAA			; squence obligatoire
			MOVWF	EECON2			
			BSF		EECON1, WR		; criture
			BCF		EECON1, WREN	; re-scurise l'eeprom
			BCF		STATUS, RP0		; retour bank 0
			RETURN

readeprom	BCF		STATUS, RP0		; bank 0
			MOVWF	EEADR			; W contient dj l'adresse  lire -> EEADR
			BSF		STATUS, RP0		; bank 1
			BSF		EECON1, RD
			BCF		STATUS, RP0		; retour bank 0
			RETURN					; EEDATA contient la valeur de l'adresse indique

reinit		MOVLW	0x01
			CALL	LCD_CMD			; efface cran
			CALL	delai25ms		; pause pour effacer l'cran+antirebond
			MOVLW	LOW pt_ADCpH7
			CALL	readeprom		; EEDATA contient la valeur par dfaut
			MOVLW	LOW	et_ADCpH7
			MOVWF	EEADR			; indique l'adresse cible
			CALL	writeprom		; crit la valeur par dfaut  l'emplacement et_
			CALL	delai25ms
			MOVLW	LOW pt_ADCpH4
			CALL	readeprom		; EEDATA contient la valeur par dfaut
			MOVLW	LOW	et_ADCpH4
			MOVWF	EEADR			; indique l'adresse cible
			CALL	writeprom		; crit la valeur par dfaut  l'emplacement et_
			CALL	delai25ms
			CALL 	initpHADC		; rcupre les valeurs ADC d'talonnage depuis l'eeprom
			CALL 	calculAB		; calcule les nouveaux coefficients A et B	
			GOTO	main			; retour dbut programme 

etalon		MOVLW	0x01
			CALL	LCD_CMD
			CALL	delai25ms		; pause pour effacer l'cran + antirebond
rebeta1		BTFSS	PORTB, BPselect	; antirebond
			GOTO	rebeta1
			CALL	delai25ms		; antirebond
etalon1		CALL	delai250ms		; pause 250ms
			MOVLW	DEBUTLIGNE1
			CALL	LCD_CMD
			CALL 	ReadADC
			CALL	calculpH
			CALL	bcd5
			MOVLW	LOW msg_ok
			CALL	AFFICHE			; "04.45 OK?"
			MOVLW	DEBUTLIGNE2
			CALL	LCD_CMD
			MOVLW	LOW msg_mes
			CALL	AFFICHE			; "MESURE"
			MOVLW	LOW msg_rsol
			CALL	AFFICHE			; "MESURER SOL pH"
			MOVLW	"4"
			CALL	LCD_CAR			; "MESURER SOL pH4"
			BTFSC	PORTB, BPselect	; OK?
			GOTO	etalon1

			MOVF	ADCresult, w
			MOVWF	EEDATA
			MOVLW	LOW et_ADCpH4
			MOVWF	EEADR
			CALL	writeprom			
			CALL	delai25ms		; antirebond

rebetal2	BTFSS	PORTB, BPselect
			GOTO	rebetal2
			CALL	delai25ms
etalon2		CALL	delai250ms		; pause 250ms
			MOVLW	DEBUTLIGNE1
			CALL	LCD_CMD
			CALL 	ReadADC
			CALL	calculpH
			CALL	bcd5
			MOVLW	LOW msg_ok
			CALL	AFFICHE			; "07.50 OK?"
			MOVLW	DEBUTLIGNE2
			CALL	LCD_CMD
			MOVLW	LOW msg_mes
			CALL	AFFICHE			; "MESURE"
			MOVLW	LOW msg_rsol
			CALL	AFFICHE			; "MESURER SOL pH"
			MOVLW	"7"
			CALL	LCD_CAR			; "MESURER SOL pH7"
			BTFSC	PORTB, BPselect	; OK?
			GOTO	etalon2
			
			MOVF	ADCresult, w
			MOVWF	EEDATA
			MOVLW	LOW et_ADCpH7
			MOVWF	EEADR
			CALL	writeprom
			CALL	delai25ms			
			
etal2_reb	BTFSS	PORTB, BPselect
			GOTO	etal2_reb
			CALL 	initpHADC		; rcupre les valeurs ADC d'talonnage depuis l'eeprom
			CALL 	calculAB		; calcule les nouveaux coefficients A et B	
			MOVLW	0x01			; efface cran
			CALL	LCD_CMD
			GOTO	main			; retour dbut programme

delai25ms	MOVLW	0x87			;24998 cycles
			MOVWF	TEMP1
			MOVLW	0x14
			MOVWF	TEMP2
Delay_25ms	DECFSZ	TEMP1, f
			GOTO	$+2
			DECFSZ	TEMP2, f
			GOTO	Delay_25ms			
			RETURN					;2 cycles
						
delai250ms	MOVLW	0x4F			;249998 cycles
			MOVWF	TEMP1
			MOVLW	0xC4
			MOVWF	TEMP2
Delay_250ms	DECFSZ	TEMP1, f
			GOTO	$+2
			DECFSZ	TEMP2, f
			GOTO	Delay_250ms
			RETURN					;2 cycles
	
			DT "(c) F. GRAS 06/2005"


;***********************************************************************************************		
		ORG	0x2100	
;				"****************"
msg_mes		DE	"MESURE", 0		; 7					
msg_ph		DE	" pH= ", 0		; 13 "MESURE PH= 07.15"  total 16 caractres
msg_rsol	DE	"R SOL pH", 0	; 22 "MESURER SOL "  total 12 caractres
msg_etal	DE  "ETALONNAGE", 0	; 33
msg_ok		DE	" OK ?", 0		; 39
msg_menu	DE	"MENU", 0		; 44
msg_init	DE	"REINIT", 0		; 51

		ORG 0x2100 + .60
pt_ADCpH7	DT .128		; valeur par dfaut
pt_ADCpH4	DT .160		; valeur par dfaut
et_ADCpH7	DT .128		; valeur aprs talonnage
et_ADCpH4	DT .160		; valeur aprs talonnage (peut tre rinitialise aux valeurs par dfaut)

		END
