// bibliotheque de gestion de l'UART des PIC 16 et 18
// Jean-Pierre MANDON 2004

char ligne[20];                // buffer de reception
char wpointer,rpointer;        // pointeur de lecture et pointeur d'ecriture
bit flag;                      // drapeau

void setup_UART(void)
{
#if ((FOSC/(16 * BAUD))-1) < 256
      BRGH=1;
      #asm
      #define DIVISEUR (FOSC/(16 * BAUD))-1
      movlw DIVISEUR
      movwf SPBRG
      #endasm
#else
      BRGH=0;
      #asm
      #define DIVISEUR (FOSC/(64 * BAUD))-1
      movlw DIVISEUR
      movwf SPBRG
      #endasm
#endif
RCSTA=0x90;
TXEN=1;
RCIE=0;                             //validation des interruptions
PEIE=0;
}

void printf(char caractere)	    // criture d'un caractere dans l'UART
{
while (!TRMT);			    // registre de transmission vide ?
TXREG=caractere;		    // oui alors envoi du caractere
}


void print_str(const char* text)    // criture d'une chaine de caractre
{
char i=0;
while ( text[i] != 0 )
    printf( text[i++] );
}

void print_dec(char valeur)
{
  char i;

  i=valeur/100;
  printf(i+48);
  valeur=valeur%100;
  i=valeur/10;
  printf(i+48);
  i=valeur%10;
  printf(i+48);
  print_str("\n\r");
}

void rxint(void)
{
char caractere;
char newwp;

     RCIF=0;
     caractere=RCREG;
     if (wpointer!=9)
	newwp=wpointer+1;
     else
	newwp=1;

     if (rpointer!=newwp)
	ligne[wpointer++]=caractere;

     if (wpointer==10)
	 wpointer=1;
}

char getch()
{
char caractere;

if (wpointer!=rpointer)
    {
    caractere=ligne[rpointer++];
    if (rpointer==10)
	rpointer=1;
    flag=1;
    }
    else
    {	 flag=0;
    }
return(caractere);
}
