//==============================================================
//	Nom Programme	: Robot_IR.c
//	Date		: 5-05-2005
//	Version		: 1.2
//	Auteur		: F. Giamarchi
//
//	Description	: Contrle d'un robot mobile par liaison IR
//
//	Reoit des donnes par le port srie  2400 baud
//	et pilote deux moteurs CC par les sorties MLI
//
//	Ce programme est oprationnel
//==============================================================
//	Configuration du microcontrleur
//==============================================================
#include <16F873.H>
//#device adc = 8
#use Delay(Clock=4000000)		// Frquence du quartz : 4Mhz
#fuses   XT,NOPROTECT,NOWDT,NOLVP,NOBROWNOUT		// Dfinitions des fusibles
#use rs232(baud=2400, xmit=PIN_C6, rcv=PIN_C7)	// RS232 hardware avec RB2 en reception et RB5 en mission

//==============================================================
//	Dclaration les variables globales
//==============================================================
int i,j, alpha, alpha_av, alpha_au, alpha_com, mesure_bat;
char data_in, data_mem, data_old;
short	Led_D_Cli, Led_G_Cli, Cli_D, Cli_G, Avance, Autre, Bip, Bip_Etat, Bip_cadence, Bip_cadence_etat;
#define	Text	'R','o','b','o','t',' ','I','R'
#define Led_D	pin_B6		// pin B6
#define Led_G	pin_B7		// pin B7
#define Relais_D	pin_C3
#define Relais_G	pin_B5
#define Buzzer	pin_C4
#define Poussoir	pin_C5		// pin C5
//==============================================================
//	Dbut du programme
//==============================================================
void	INIT_Interrup()
{
setup_counters(rtcc_internal,rtcc_div_4);
enable_interrupts(int_rtcc);
enable_interrupts(global);
set_rtcc(0x00);
}
//==============================================================
void	main(void)
{
#rom	0x2100 ={Text};
// Initialisation des ports
set_tris_a (0x01);		// 0000 0001
set_tris_b (0x00);		// 0000 0000
set_tris_c (0xA0);		// 1010 0000
output_a (0);
output_b (0);
//output_c (0);
//======================================
// Initialisation des PWM
setup_ccp1(CCP_PWM);   // Configure CCP1 pour PWM
setup_ccp2(CCP_PWM);   // Configure CCP1 pour PWM
setup_timer_2(T2_DIV_BY_4, 127, 1);
alpha = 0;
alpha_com = 0;
set_pwm1_duty(alpha);			// MLI de alpha
set_pwm2_duty(alpha);			// MLI de alpha

alpha_av = read_eeprom(0x10);
if (alpha_av == 0xFF)
	alpha_av = 20;
alpha_au = read_eeprom(0x11);
if (alpha_au == 0xFF)
	alpha_au = 20;
//======================================
// Initialisations diverses
Bip = 0;		
j = 0;
Avance = 0;
Autre = 0;
//======================================
// Initialisation de la ligne RA0 en entre analogique
setup_adc_ports( RA0_ANALOG );
setup_adc( ADC_CLOCK_INTERNAL );
set_adc_channel( 0 );
//======================================
delay_ms(1000);
printf ("\n\rTest Dialogue RS232");	// envoie un message sur la liaison srie
printf ("\n\r");
for (i=0; i<10; i++)		// routine de test
	{						// fait clignoter deux Dels
	output_high(Led_D);
	output_low(Led_G);
	delay_ms(300);
	output_high(Led_G);
	output_low(Led_D);
	delay_ms(300);
	}
Led_D_Cli = 0;
Led_G_Cli = 0;
output_low(Led_D);
output_low(Led_G);
Bip =0;
Bip_cadence = 0;
//======================================
INIT_Interrup();
delay_ms(100);
Bip =1;
delay_ms(1000);
Bip =0;
data_old = 'q';
//======================================
// test batterie: 4,8 Volts -> 128
/*
mesure_bat = read_adc();
delay_ms(100);
while (mesure_bat < 50)		// batterie  4,0 Volts ( 106)
	{
	Bip_cadence = 1;
	Led_D_Cli = 1;
	Led_G_Cli = 1;
	}	
Bip_cadence = 0;	
Led_D_Cli = 0;
Led_G_Cli = 0;
*/
//======================================
while(true)
	{
	do	{
		data_in = getch();
			if (data_in == 'e')		// si appui sur e (avance)
				{
				data_old = data_in;
				Avance = 1;
				Autre = 0;
				Led_D_Cli = 0;
				Led_G_Cli = 0;
				Bip_cadence = 0;
				output_high(Led_D);
				output_high(Led_G);

				alpha_com = alpha_av;
				delay_ms(100);
				output_low(Relais_D);
				output_low(Relais_G);
				}
			else if (data_in == 'x')		// si appui sur x (recule)
				{
				data_old = data_in;
				Avance = 0;
				Autre = 1;
				Led_D_Cli = 1;
				Led_G_Cli = 1;
				Bip_cadence = 1;

				alpha_com = alpha_au;
				delay_ms(100);
				output_high(Relais_D);
				output_high(Relais_G);
				}
			else if (data_in == 'd')		// si appui sur d (droite)
				{
				data_old = data_in;
				Avance = 0;
				Autre = 1;
				output_low(Led_D);
				output_low(Led_G);
				Led_D_Cli = 1;
				Led_G_Cli = 0;
				Bip_cadence = 0;

				alpha_com = alpha_au;
				delay_ms(100);
				output_high(Relais_D);
				output_low(Relais_G);
				}
			else if (data_in == 's')		// si appui sur s (gauche)
				{
				data_old = data_in;
				Avance = 0;
				Autre = 1;
				output_low(Led_D);
				output_low(Led_G);
				Led_D_Cli = 0;
				Led_G_Cli = 1;
				Bip_cadence = 0;

				alpha_com = alpha_au;
				delay_ms(100);
				output_low(Relais_D);
				output_high(Relais_G);

				}
			else if (data_in == 'q')		// si appui sur Stop (q)
				{
				data_old = data_in;
				Avance = 0;
				Autre = 0;
				Led_D_Cli = 0;
				Led_G_Cli = 0;
				Bip_cadence = 0;
				output_low(Led_D);
				output_low(Led_G);

				alpha_com = 0;
				delay_ms(100);
				output_low(Relais_D);
				output_low(Relais_G);
				}
			else if (data_in == 'v')		// si appui sur v (Version)
				printf ("Version 1.0");		// envoie un message
			else if (data_in == 'o')		// si appui sur o
				{
				data_old = data_in;
				if (Avance)
					{
					alpha_av ++;			// Acclration
					if (alpha_av > 80)
							alpha_av = 80;
					alpha_com = alpha_av;
					}
				else if (Autre)
					{
					alpha_au ++;			// Acclration
					if (alpha_au > 80)
							alpha_au = 80;
					alpha_com = alpha_au;
					}
				}
			else if (data_in == 'l')		// si appui sur l
				{
				data_old = data_in;
				if (Avance)
					{
					alpha_av --;			// Dcclration
					if (alpha_av < 10)
							alpha_av = 10;
					alpha_com = alpha_av;
					}
				else if (Autre)
					{
					alpha_au --;			// Acclration
					if (alpha_au < 10)
							alpha_au = 10;
					alpha_com = alpha_au;
					}
				}
			else
				data_in = data_old;				// supprime les codes erronns
		} while (data_in != 'q');	// si appui sur q
	output_low(Led_D);
	output_low(Led_G);
	write_eeprom(0x10,alpha_av);
	write_eeprom(0x11,alpha_au);
	}
}
//==============================================================
//	Sous programme d'interruption
//	1. rinitialise rtcc pour la prochaine interruption	
//	2. permet le clignotement de 2 Dels
//	3. rampe d'acclration et de dcclration
//	4. Buzzer  1kHz
#int_rtcc
void millisec_int(void)
{
//======================================
//	rinitialise rtcc
set_rtcc(14);
//======================================
i++;
if (i == 250)
	{
	i = 0;

	if (Led_D_Cli)
		{
		if (Cli_D)
			{
			output_high(Led_D);
			Cli_D = 0;
			}
		else
			{
			output_low(Led_D);
			Cli_D = 1;
			Cli_G = 0;		// Synchronise le clignotement des 2 dels
			}
		}

	if (Led_G_Cli)
		{
		if (Cli_G)
			{
			output_low(Led_G);
			Cli_G = 0;
			}
		else
			{
			output_high(Led_G);
			Cli_G = 1;
			}
		}
	if (Bip_cadence)
		{
		if (Bip_cadence_etat)
			Bip_cadence_etat = 0;
		else
			Bip_cadence_etat = 1;
		}
	else
		Bip_cadence_etat = 0;
	}
//======================================
j++;
if (j == 20)
	{
	j = 0;

	if (data_mem != data_in && data_in != 'o' && data_in != 'l')
		alpha = 0;

	if (alpha < alpha_com)
		alpha++;
	else if (alpha > alpha_com)
		alpha--;
	else
		alpha = alpha_com;

	set_pwm1_duty(alpha);			// MLI de alpha	
	set_pwm2_duty(alpha);			// MLI de alpha

	data_mem = data_in;
	}
//======================================
if (Bip || Bip_cadence)
	if (Bip_Etat || Bip_cadence_etat)
		{
		Bip_Etat = 0;
		output_low(Buzzer);
		}
	else
		{
		Bip_Etat = 1;
		output_high(Buzzer);
		}
else
	output_low(Buzzer);
}
//==============================================================
