/***************************************************************************
 *****                                                                 *****
 *****                                                                 *****
 ***************************************************************************/

//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TMainForm *MainForm;
//---------------------------------------------------------------------------
 __fastcall TMainForm::TMainForm(TComponent* Owner): TForm(Owner)
{
  if (openpipe())                                     // start pipe
    Timer1->Enabled = TRUE;                           // if OK, start transfer
  else
    StatusBar->SimpleText = "Acces au module USB impossible, relancez l'application";
StepperaToDo=false;
StepperbToDo=false;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormDestroy(TObject *Sender)
{
  closepipe();                                        // stop pipe
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::Timer1Timer(TObject *Sender)
{
short int x;
unsigned char *p;

// - - - - - - - - - - - - - - - - - - - - - - - - - -
if (StepperaToDo)
	{
    if (Stepsa>=0)
    	{
	    io_buffer.binary0=1;		// cde stepper +
    	io_buffer.binary1=(unsigned char)Stepsa;	// qt du dplacement
        }
    else
    	{
	    io_buffer.binary0=2;		// cde stepper -
    	io_buffer.binary1=(unsigned char)-Stepsa;	// qt du dplacement
        }
    StepperaToDo=false;			// cde prise en compte
    }
else
	{
    // - - - - - - - - - - - - - - - - - - - - - - - - - -
    if (SpeedaToDo)
    	{
	    io_buffer.binary0=3;		// cde speed
    	io_buffer.binary1=(unsigned char)Speeda;	// vitesse du dplacement
	    SpeedaToDo=false;			// cde prise en compte
        }
    else
    	{
        // - - - - - - - - - - - - - - - - - - - - - - - - - -
        if (StopaToDo)
        	{
		    io_buffer.binary0=4;		// cde stop
		    StopaToDo=false;			// cde prise en compte
            }
		else
    		{
            // - - - - - - - - - - - - - - - - - - - - - - - - - -
            if (StepperbToDo)
            	{
                if (Stepsb>=0)
                	{
            	    io_buffer.binary0=5;		// cde stepper +
                	io_buffer.binary1=(unsigned char)Stepsb;	// qt du dplacement
                    }
                else
                	{
            	    io_buffer.binary0=6;		// cde stepper -
                	io_buffer.binary1=(unsigned char)-Stepsb;	// qt du dplacement
                    }
                StepperbToDo=false;			    // cde prise en compte
                }
            else
            	{
                // - - - - - - - - - - - - - - - - - - - - - - - - - -
                if (SpeedbToDo)
                	{
            	    io_buffer.binary0=7;		// cde speed
                	io_buffer.binary1=(unsigned char)Speedb;	// vitesse du dplacement
            	    SpeedbToDo=false;			// cde prise en compte
                    }
                else
                	{
                    // - - - - - - - - - - - - - - - - - - - - - - - - - -
                    if (StopbToDo)
                    	{
            		    io_buffer.binary0=7;		// cde stop
            		    StopbToDo=false;			// cde prise en compte
                        }
                    else
                        {
            			io_buffer.binary0=0;	// cde = nop
            	    	}
                    }
                }
            }
        }
    }

if (xferpipe(&io_buffer))                        // transmit & receive
    {
    StatusBar->SimpleText = "Liaison USB tablie"; // xfer was OK
	p=(unsigned char*)&x;
    *p++=io_buffer.binary0;
    *p=io_buffer.binary1;
   	LabelStepaInProgress->Caption=(float)x;
	p=(unsigned char*)&x;
    *p++=io_buffer.binary2;
    *p=io_buffer.binary3;
   	LabelStepbInProgress->Caption=(float)x;
    }
  else                                       // xfer FAILED
    {
    StatusBar->SimpleText = "Erreur de communication";
    }
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
//----- The following code will be compiled if the "UseUSBpipe" label  ------
//----- is defined.                                                    ------
//----- Data transfer will happen over USB port. Make sure that the    ------
//----- "usbio.sys" driver is installed correctly!                     ------
//---------------------------------------------------------------------------

bool TMainForm::openpipe(void)
{
  const GUID g_UsbioID = USBIO_IID;      // globally unique identifier for
                                         // "usbio.sys"-driver (see Win32 SDK)
  USB_DEVICE_DESCRIPTOR desc;
  USBIO_SET_CONFIGURATION conf;

  conf.ConfigurationIndex = 0;           // select configuration 0 on USB08-board
  conf.NbOfInterfaces = 1;               // one interface to configure
  conf.InterfaceList[0].InterfaceIndex = 0;         // settings of this
  conf.InterfaceList[0].AlternateSettingIndex = 0;  // interface
  conf.InterfaceList[0].MaximumTransferSize = 8;

  HDEVINFO g_DevList = CUsbIo::CreateDeviceList(&g_UsbioID); // creating a list of
                                                             // all devices connected
                                                             // to USB
  if (g_DevList != NULL)
    for (int i = 0; i < 127; i++)                   // scan USB for our HC08-board
      if (!UsbIo.Open(i, g_DevList, &g_UsbioID)) {  // try to open device
        if (!UsbIo.GetDeviceDescriptor(&desc))      // get descriptor
          if (desc.idVendor == HC08_ID_VENDOR &&    // check for match of vendor
             desc.idProduct == HC08_ID_PRODUCT)     // and product IDs
            return !UsbIo.SetConfiguration(&conf) &&                     // configure device
                   !UsbIoPipeIn.Bind(i, 0x81, g_DevList, &g_UsbioID) &&  // bind in and
                   !UsbIoPipeOut.Bind(i, 0x02, g_DevList, &g_UsbioID); } // out pipes
      else
        break;
  return FALSE;          // if UsbIo.Open failed, stop scanning USB
}
//---------------------------------------------------------------------------
bool TMainForm::xferpipe(Tio_buffer *io_buffer)
{
  unsigned long ByteCount;

  return !UsbIoPipeOut.WriteSync(io_buffer, ByteCount = sizeof(Tio_buffer), 1000) &&
         ByteCount == sizeof(Tio_buffer) &&
         !UsbIoPipeIn.ReadSync(io_buffer, ByteCount = sizeof(Tio_buffer), 1000) &&
         ByteCount == sizeof(Tio_buffer);
}
//---------------------------------------------------------------------------
bool TMainForm::closepipe(void)
{
  UsbIoPipeIn.Close();
  UsbIoPipeOut.Close();
  UsbIo.Close();

  return TRUE;                  // Close is always TRUE
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Button1Click(TObject *Sender)
{
int x;

try
	{
    x=EditStepsa->Text.ToInt();
    if (x<-127) x=-127;
    if (x>127) x=127;

    if (!StepperaToDo)
    	{
	    StepperaToDo=true;
        Stepsa=x;
	    EditStepsa->Text=x;
        }
    }
catch(...)
	{
    MessageBeep(-1);
    }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Button3Click(TObject *Sender)
{
int x;

try
	{
    x=EditSpeeda->Text.ToInt();
    if (x<1) x=1;
    if (x>255) x=255;

    if (!SpeedaToDo)
    	{
	    SpeedaToDo=true;
        Speeda=x;
	    EditSpeeda->Text=x;
        }
    }
catch(...)
	{
    MessageBeep(-1);
    }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Button2Click(TObject *Sender)
{
StopaToDo=true;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::FinClick(TObject *Sender)
{
Close();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Button4Click(TObject *Sender)
{
int x;

try
	{
    x=EditStepsb->Text.ToInt();
    if (x<-127) x=-127;
    if (x>127) x=127;

    if (!StepperbToDo)
    	{
	    StepperbToDo=true;
        Stepsb=x;
	    EditStepsb->Text=x;
        }
    }
catch(...)
	{
    MessageBeep(-1);
    }

}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Button6Click(TObject *Sender)
{
int x;

try
	{
    x=EditSpeedb->Text.ToInt();
    if (x<1) x=1;
    if (x>255) x=255;

    if (!SpeedbToDo)
    	{
	    SpeedbToDo=true;
        Speedb=x;
	    EditSpeedb->Text=x;
        }
    }
catch(...)
	{
    MessageBeep(-1);
    }

}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Button5Click(TObject *Sender)
{
StopbToDo=true;
}
//---------------------------------------------------------------------------

