/************************************************************************
 *
 *  Module:       UsbIoWriter.h
 *  Long name:    CUsbIoWriter class
 *  Description:  Writes a data stream to a pipe using a thread
 *
 *  Runtime Env.: Win32, Part of UsbioLib
 *  Author(s):    Guenter Hildebrandt, Udo Eberhardt
 *  Company:      Thesycon GmbH, Ilmenau
 ************************************************************************/

#ifndef _UsbIoWriter_h_
#define _UsbIoWriter_h_

#include "UsbIoThread.h"



//
// CUsbIoWriter
//
// This class implements a worker thread that
// continuously writes a data stream to a pipe.
//
class CUsbIoWriter : public CUsbIoThread
{
public:
  // standard constructor
  CUsbIoWriter();
  // destructor
  virtual ~CUsbIoWriter();


// implementation:
protected:

  // from base class
  virtual void ThreadRoutine();
  virtual void TerminateThread();

}; // class CUsbIoWriter


#endif //_UsbIoWriter_h_
 
/*************************** EOF **************************************/
