
Rem ##################################################################
Rem ##= Yves MERGY (c) 03/2005 -=====- pour ELECTRONIQUE PRATIQUE  =##
Rem ##= CARTE D'EXPERIMENTATIONS POUR C. PIC PRO de chez DIGIMOG  =##
REM ##=  PROGRAMME DE TEST V1.0    dvelopp avec Basic Pic Pro    =##
Rem ##################################################################
Rem
Rem ==================================================================
Rem == RACCORDEMENTS ELECTRIQUES SUR LA PLATINE AVEC UN PIC PRO 452 ==
Rem ==================================================================
Rem == L'AFFICHEUR LCD: =========================
Rem =========== RW n'est pas utilis (reli  la masse sur la platine par une rsistance de 10k)
Rem =========== D0  D3 ne sont pas utiliss	
Rem =========== E  reli au PORT_E.0
Rem =========== RS reli au PORT_E.2
Rem =========== D4 reli au PORT_D.4
Rem =========== D5 reli au PORT_D.5
Rem =========== D6 reli au PORT_D.6
Rem =========== D7 reli au PORT_D.7
Rem == LE CLAVIER MATRICE: ======================
Rem =========== Y1 reli au PORT_B.0
Rem =========== Y2 reli au PORT_B.1
Rem =========== Y3 reli au PORT_B.2
Rem =========== Y4 reli au PORT_B.3
Rem =========== X1 reli au PORT_B.4
Rem =========== X2 reli au PORT_B.5
Rem =========== X3 reli au PORT_B.6
Rem =========== X4 reli au PORT_B.7
Rem == LE BUZZER PIEZO: =========================
Rem =========== BUZ reli au PORT_D.3
Rem == LES TOUCHES INDIVIDUELLES: ===============
Rem =========== BP1 reli au PORT_A.0
Rem =========== BP2 reli au PORT_A.1
Rem =========== BP3 reli au PORT_A.2
Rem =========== BP4 reli au PORT_A.3
Rem == LES HUIT LEDS: ===========================
Rem =========== L1 reli au PORT_C.0
Rem =========== L2 reli au PORT_C.1
Rem =========== L3 reli au PORT_C.2
Rem =========== L4 reli au PORT_C.3
Rem =========== L5 reli au PORT_C.4
Rem =========== L6 reli au PORT_C.5
Rem =========== L7 reli au PORT_C.6
Rem =========== L8 reli au PORT_C.7
Rem ==================================================================

Include "18F452P.INC"		'Programme pour PIC PRO 452 ou PICPIC18F452

Rem ===========================================================================
Rem ========================= DEBUT DU MODULE =================================
Rem ===========================================================================
Rem == MODULE "16TOUCHES.BAS" destin  la gestion du CLAVIER MATRICE =========
Rem ==                                                                       ==
Rem == Ce module a t lgrement modifi par Yves MERGY pour retouner une   ==
Rem == valeur comprise entre 0 et 16.                                        ==
Rem == Une valeur de 0  15 correspond  la touche actionne.                ==
Rem == Une valeur 16 correspond au clavier sans action.                      ==
Rem == Il est prfrable d'enregistrer ce module sous un nom diffrent que   ==
Rem == "16TOUCHES.BAS". par exemple: "16TOUCHES_N.BAS", mais dans le mme    ==
Rem == rpertoire.                                                           ==
Rem == Par la suite, il suffira d'employer la directive "include" suivie du  ==
Rem == nouveau nom de fichier.                                               ==
Rem ===========================================================================
Rem
rem configurez le port A en port digital s'il est utilis avce le clavier

Declare Function LireClavier()  As  Byte                    

Bit  _L1    At   PORTB.7               'avec resistance de protection 0K300
Bit  _L2    At   PORTB.6
Bit  _L3    At   PORTB.5
Bit  _L4    At   PORTB.4
Bit  _C1    At   PORTB.3
Bit  _C2    At   PORTB.2
Bit  _C3    At   PORTB.1                 
Bit  _C4    At   PORTB.0

Function LireClavier()  As  Byte                    

     rem une des deux lignes suivantes sert seulement avec le port A
     'PCFG0=1 : PCFG1=1               'Port A digital - PIC16C715
     'PCFG2=1 : PCFG1=1               'Port A digital - PIC16F87X

     PullUpBit=PULLUP                'PORTB pull-ups ON-valable pour tout PIC16,PORTB

      Pause 50                       'ms 
     'Pause 500                      'ms 

     Input  _C1                      'colonnes en entre  et  5 V par pull-up
     Input  _C2
     Input  _C3
     Input  _C4


     Output _L1                      'lignes en sortie 
     Output _L2
     Output _L3
     Output _L4
     
     _L4=1:_L3=1:_L2=1:_L1=0
     Nop                              'sinon '1' ignor 
     If _C1= 0 Then Return(12)       
     If _C2= 0 Then Return(11)       
     If _C3= 0 Then Return(0)       
     If _C4= 0 Then Return(10)       

     _L4=1:_L3=1:_L2=0:_L1=1
     If _C1= 0 Then Return(13)       
     If _C2= 0 Then Return(9)       
     If _C3= 0 Then Return(8)       
     If _C4= 0 Then Return(7)       

     _L4=1:_L3=0:_L2=1:_L1=1
     If _C1= 0 Then Return(14)       
     If _C2= 0 Then Return(6)       
     If _C3= 0 Then Return(5)       
     If _C4= 0 Then Return(4)       

     _L4=0:_L3=1:_L2=1:_L1=1
     If _C1= 0 Then Return(15)       
     If _C2= 0 Then Return(3)       
     If _C3= 0 Then Return(2)       
     If _C4= 0 Then Return(1)       

   
     Return(16)                        'pas de touche

     End Function
Rem ===========================================================================
Rem ========================= FIN DU MODULE ===================================
Rem ===========================================================================



Rem ===========================================================================
Rem ========================= DEBUT DU MODULE =================================
Rem ===========================================================================
Rem == MODULE "LCD.BAS" destin  la gestion d'un AFFICHEUR LCD 2x16  =========
Rem ==                                                                       ==
Rem == Ce module a t lgrement modifi par Yves MERGY pour grer un       ==
Rem == afficheur de 4 lignes de 16 ou 20 caractres.                         ==
Rem == Il est prfrable d'enregistrer ce module sous un nom diffrent que   ==
Rem == "LCD.BAS". par exemple: "LCD_4L.BAS", mais dans le mme rpertoire.   ==
Rem == Par la suite, il suffira d'employer la directive "include" suivie du  ==
Rem == nouveau nom de fichier.                                               ==
Rem ===========================================================================
Rem
'picdem2plus utilise le port  A 
'  ADCON1 = 00001110b          
'   Output PA2          'R/W
'   PA2 =0              'non utilis par LCD.bas
'LCD.BAS    4-Bit DATA INTERFACE    LCD configur broche par broche
rem 2 lignes ou plus
rem voir LCD1.bas pour LCD 1 ligne 2*8 caractres
'---------------------------------------------------------------------
'                         LCD Carte13
'---------------------------------------------------------------------
'VSS                             broche 1
'5V                              broche 2
'VO                              broche 3  contraste
''Bit  LCD_RS     at   PORTD.2    'broche 4
'Bit  LCD_RW                    'broche 5 relie la masse 
''Bit  LCD_E      at   PORTC.5   'broche 6
''Bit  LCD_DATA4  at   PORTD.4    'broche 11  
''Bit  LCD_DATA5  at   PORTD.5    'broche 12  
''Bit  LCD_DATA6  at   PORTD.6    'broche 13  
''Bit  LCD_DATA7  at   PORTD.7    'broche 14
'NC                              broche 15
'NC                              broche 26
'---------------------------------------------------------------------

'---------------------------------------------------------------------
'                         LCD Pack Education
'---------------------------------------------------------------------
rem au reset le port E est configiur en port analogique
rem il faut le configurer en port digital pour l'utiliser avec un LCD
Bit  LCD_DATA4  at   PORTD.4       
Bit  LCD_DATA5  at   PORTD.5       
Bit  LCD_DATA6  at   PORTD.6       
Bit  LCD_DATA7  at   PORTD.7       
Bit  LCD_E      at   PORTE.0
'Bit  LCD_RW                     'RW reli la masse 
Bit  LCD_RS     at   PORTE.2      
'---------------------------------------------------------------------
'                         LCD  PicDem 2 Plus 
'---------------------------------------------------------------------
'Bit  LCD_DATA4  at   PORTD.0       
'Bit  LCD_DATA5  at   PORTD.1       
'Bit  LCD_DATA6  at   PORTD.2       
'Bit  LCD_DATA7  at   PORTD.3       
'Bit  LCD_E      at   PORTA.1       
'Bit  LCD_RW     at   PORTA.2       'LCD_RW  relier  la masse ca non utilis ici
'Bit  LCD_RS     at   PORTA.3       

Declare Sub   Locate      ( _R0,_R1)
Declare  Sub  PrintCar    ( _R0 )                  'R0 =Byte  
Declare  Sub  PrintNum16  ( _R23 )                 'R23 =R2-R3 =word
Declare  Sub  PrintEndl   ( ) 
Declare  Sub  LcdCmnd     ( _R0 )
Declare  Sub  LcdInit     ( )        
Declare  Sub  LcdClear    ( )         
Declare  Sub  CLS         ( )         

Sub Locate (Byte x, Byte y)
   Select x
       case 1:LcdCmnd(0x80+0x00+y-1)                'adresse ligne 1 = 0x0
       case 2:LcdCmnd(0x80+0x40+y-1)                'adresse ligne 2 = 0x40
       case 3:LcdCmnd(0x80+0x14+y-1)                'adresse ligne 3 = 0x14
       case 4:LcdCmnd(0x80+0x54+y-1)                'adresse ligne 4 = 0x54
   End Select
   End Sub
Sub PrintEndl  ()      
   Nop
   End Sub

Sub PrintCar(Byte c)   rem asm --> printcar_
   '  adapter si LCD_DATA n'est pas poids fort du port   
   Pause 1
   'LCD_DATA = c and 0xF0
   LCD_E=1
   LCD_RS=1
   If c.7 = 1 Then LCD_DATA7=1 Else LCD_DATA7=0
   If c.6 = 1 Then LCD_DATA6=1 Else LCD_DATA6=0
   If c.5 = 1 Then LCD_DATA5=1 Else LCD_DATA5=0
   If c.4 = 1 Then LCD_DATA4=1 Else LCD_DATA4=0
   'LCD_RW=0
   Nop
   LCD_E=0  
   Pause 1
   'Swap c
   'LCD_DATA = c and 0xF0
   LCD_E=1
   If c.3 = 1 Then LCD_DATA7=1 Else LCD_DATA7=0
   If c.2 = 1 Then LCD_DATA6=1 Else LCD_DATA6=0
   If c.1 = 1 Then LCD_DATA5=1 Else LCD_DATA5=0
   If c.0 = 1 Then LCD_DATA4=1 Else LCD_DATA4=0
   'LCD_RW=0
   Nop
   LCD_E=0
End Sub

Sub PrintNum16(word v)            'utilise les variables globales libre  cet isntant
   Static Byte  n   at  _R4
   Static Byte  r2  at  _R5
   Static Byte  r1  at  _R6
   Static Byte  r0  at  _R7
   'convertir un hexadcimal v en BCD r2 r1 r0
   r2=0 : r1=0 : r0=0 
   n=16
   Do While(1)
      rol v
      rol r0
      rol r1
      rol r2
      n=n-1
      If n=0 Then Exit While
      If ( (r0+0x03) and   8) <> 0 Then r0=r0+0x03
      If ( (r0+0x30) and 128) <> 0 Then r0=r0+0x30
      If ( (r1+0x03) and   8) <> 0 Then r1=r1+0x03
      If ( (r1+0x30) and 128) <> 0 Then r1=r1+0x30
      If ( (r2+0x03) and   8) <> 0 Then r2=r2+0x03
      If ( (r2+0x30) and 128) <> 0 Then r2=r2+0x30
   loop        
   n=0
   If r2 <>  0x00            Then  n = n+1           ' 5 chiffres
   If r1 >=  0x10  or n <> 0 Then  n = n+1
   If r1 <>  0x00  or n <> 0 Then  n = n+1
   If r0 >=  0x10  or n <> 0 Then  n = n+1
   If n >= 4 Then PrintCar ( (r2 and 0x0F) + '0')
   Swap r1
   If n >= 3 Then PrintCar ( (r1 and 0x0F) + '0' ) 
   Swap r1 
   If n >= 2 Then PrintCar ( (r1 and 0x0F) + '0')
   Swap r0
   If n >= 1 Then PrintCar ( (r0 and 0x0F) + '0')
   Swap r0
   PrintCar ( (r0 and 0x0F) + '0')
   End Sub

Sub LcdCmnd(Byte c)     rem LCD_RS=0 command mode 
   Pause 5
   LCD_E  = 1
   LCD_RS = 0 
   'LCD_RW = 0
   If c.7 = 1 Then LCD_DATA7=1 Else LCD_DATA7=0
   If c.6 = 1 Then LCD_DATA6=1 Else LCD_DATA6=0
   If c.5 = 1 Then LCD_DATA5=1 Else LCD_DATA5=0
   If c.4 = 1 Then LCD_DATA4=1 Else LCD_DATA4=0
   Nop
   LCD_E  = 0 
   Pause 5
   LCD_E  = 1
   If c.3 = 1 Then LCD_DATA7=1 Else LCD_DATA7=0
   If c.2 = 1 Then LCD_DATA6=1 Else LCD_DATA6=0
   If c.1 = 1 Then LCD_DATA5=1 Else LCD_DATA5=0
   If c.0 = 1 Then LCD_DATA4=1 Else LCD_DATA4=0
   Nop
   LCD_E  = 0   
   Pause 5
   End Sub
Sub LcdClear()                           'LCD_RS=0 command mode 
   LcdCmnd(0x01)
   End Sub
Sub CLS()                                'LCD_RS=0 command mode 
   LcdCmnd(0x01)
   End Sub    
Sub LcdInit()
   Output LCD_DATA7
   Output LCD_DATA6
   Output LCD_DATA5
   Output LCD_DATA4
   LCD_E = 1
   Nop
   LCD_RS = 0 
   Output LCD_RS
   Output LCD_E
   'Output LCD_RW
   LCD_E = 1
   LCD_DATA7 = 0 : LCD_DATA6 = 0 : LCD_DATA5 = 1 : LCD_DATA4 = 1
   'LCD_RW = 0 
   Nop
   LCD_E = 0   
   Pause 5
   LCD_E = 1
   LCD_DATA7 = 0 : LCD_DATA6 = 0 : LCD_DATA5 = 1 : LCD_DATA4 = 1
   'LCD_RW = 0 
   Nop
   LCD_E = 0   
   Pause 1
   LCD_E = 1
   LCD_DATA7 = 0 : LCD_DATA6 = 0 : LCD_DATA5 = 1 : LCD_DATA4 = 1
   'LCD_RW = 0 
   Nop
   LCD_E = 0   
   Pause 1
   LCD_E = 1
   ' mode 4 Bit-data
   LCD_DATA7 = 0 : LCD_DATA6 = 0 : LCD_DATA5 = 1 : LCD_DATA4 = 0
   'LCD_RW = 0 
   Nop
   LCD_E = 0
   LcdCmnd(0x28)   'function Set
   LcdCmnd(0x08)   'DisplayON/OFF control 
   LcdCmnd(0x01)   'Display Clear
   LcdCmnd(0x06)   'Entry mode set 
   LcdCmnd(0x0C)   'DisplayON/OFF control   CURSOR OFF
   LcdCmnd(0x80)   'DDRAM address set  0x80+0x28 pour 2me 1/2 ligne
   Return                                   'retourner au programme
   PrintCar(0)    'pour le compilateur
   PrintNum16(0)  'pour le compilateur
   PrintEndl()
   End Sub


'----------------------------------------------------------------------------------------------
rem                   TYPE FLOAT 
'-----------------------------------------------------------------------------------------------
#if float
float print_x
declare sub   Printfloat (print_x)

SUB printfloat (float x)
    static word n
    n=x                      'partie entire sur 16 bits . 0-65535
    Print n,".";             'partie entire donc sans arrondi 
    x=x-n                    'partie dcimale     
    x=x*1000.0               '3 chiffres    x=x*10000.0 pour 4 chiffres
    n=x                      'arrondir pour afficher le dernier chiffre       
    x= x-n
    'if x >=0.5 Then n=n+ 1   '+1 si 0.5 ou plus ?????????
    if n=0 then return
    if n<10  then Print 0; 
    if n<100 then Print 0; 
    Print n
    end sub

#end if
'-----------------------------------------------------------------------------------------------
rem                                Type STRING
'-----------------------------------------------------------------------------------------------
#if string

Declare Sub      PrintStr (s1)
Declare Sub      InputString(s1)                'Entre une chane dans s1
'dclaration de s1 dans string.bas 
Sub Printstr (String s)
    Static Byte n,c                        'n peut tre globale mais dconseill
    n = 0
    c =s1[0,n]              
    If _ptr1>MAX_RAM_STRING Then c=FlashRead(_ptr1+n)'peut tre dsactive si Flash non utilis
    Do While c <>0 
      PrintCar (c)
      n = n + 1
      c=s1[0,n]              
      If _ptr1>MAX_RAM_STRING Then c=FlashRead(_ptr1+n)'peut tre dsactive si Flash non utilis
    Loop  
   End Sub    
#end if
'--------------------------------------------------------------------------------------------
Rem ===========================================================================
Rem ========================= FIN DU MODULE ===================================
Rem ===========================================================================
Rem
Rem ===========================================================================
Rem ========================= DEBUT DU PROGRAMME ==============================
Rem ===========================================================================

Rem ===== VARIABLES ===================
Word I,J
Byte  touche                     'rserve une variable pour stocker la touche saisie

Rem ===== DEBUT =======================
debut:
Rem ===== INITIALISATIONS =============
	ADCON1 = ToutDigital        'PORT_A et PORT_E configurs en port digital
	Output PORTC
	Input PORTA 
	LCDInit                     'Initialise l'afficheur
	Pause 500                   'Temporisation entre la mise sous-tension et l'accs  l'afficheur

Rem ===== 1er MESSAGE =================
	CLS                         	'Efface l'afficheur
	Locate 1,1                  	'place le curseur  la ligne 1 colonne 1
	Print "-=# ELECTRONIQUE #=-"	'affiche le texte
	Locate 2,1                  	'place le curseur  la ligne 2 colonne 1
	Print "--==# PRATIQUE #==--"  'affiche le texte
	Locate 3,1                  	'place le curseur  la ligne 3 colonne 1
	Print "Editeur TRANSOCEANIC"  'affiche le texte
	Locate 4,1                  	'place le curseur  la ligne 4 colonne 1
	Print "EXPERIMENTATIONS PIC"  'affiche le texte
	Freqout PD3,1000,500
	Pause 2000				'Temporisation

Rem ===== 2me MESSAGE ================
	CLS
	Locate 1,1
	Print "  PROGRAMME DE TEST "
	Locate 2,1
	Print "  pour PIC PRO 452  "
	Locate 3,1
	Print "  De chez DIGIMOK   "
	Locate 4,1
	Print "(c) Yves MERGY  2005"
	Freqout PD3,1000,500
	Pause 2000

Rem ===== MESSAGE DU MENU =============
Menu:
	CLS
	Locate 1,1
	Print "ACTIONNEZ UNE TOUCHE"
	Locate 2,1
	Print "B => BRUITAGE - SONS"
	Locate 3,1
	Print "C => TOUCHES ET LEDS"
	Locate 4,1
	Print "A => RETOUR AU MENU "
	Freqout PD3,1000,500

Rem ===== LECTURE DU CLAVIER ==========
Clavier:
	touche = LireClavier()			'Lit le clavier
	If touche = 16 Then Goto Clavier	'touche est <>16 si une touche est saisie
	If touche = 11 then Goto Bruits
	If touche = 10 then Goto Menu
	If touche = 12 then Goto BP_Led
	Goto Clavier

Rem ===== BOUCLE DES BRUITAGES ========
Bruits:
	CLS
	Locate 1,1
	Print "0 A 9 => SON SIMPLE "
	Locate 2,1
	Print "E ==> BRUITAGE No 1 "
	Locate 3,1
	Print "F ==> BRUITAGE No 2 "
	Locate 4,1
	Print "A => RETOUR AU MENU "
	Freqout PD3,1000,500
Clav1:
	touche = LireClavier()
	If touche < 10 Then Goto Son
	If touche = 14 then Goto Bruit1
	If touche = 15 then Goto Bruit2
	If touche = 10 then Goto Menu
	Goto Clav1

Rem ===== SON UNIQUE ==================
Son:
	I=touche
	I=(I+1)*1000
	Freqout PD3,I,5000
	Goto Clav1
Rem ===== 1er BRUITAGE MULTI-NOTES ====
Bruit1:
	For I=100 to 5000 step 100
	  Freqout PD3,I,500
	Next
	Goto Clav1
Rem ===== 2me BRUITAGE MULTI-NOTES ===
Bruit2:
	For I=100 to 5000 step 100
	  Freqout PD3,I,100
	Next
	Goto Clav1

Rem ===== BOUCLE DES CLIGNOTEMENTS ====
BP_Led:
	CLS
	Locate 1,1
	Print "APPUYEZ SUR UNE DES "
	Locate 2,1
	Print "4 TOUCHES POUR FAIRE"
	Locate 3,1
	Print "CLIGNOTER LES LEDS. "
	Locate 4,1
	Print "A => RETOUR AU MENU "
	Freqout PD3,1000,500
Cligne:
	touche = LireClavier()
	If touche = 10 then Goto Menu
	If PA0=0 then gosub Clign1
	If PA1=0 then gosub Clign2
	If PA2=0 then gosub Clign3
	If PA3=0 then PORTC=0
	Goto Cligne
Rem ===== SEQUENCE No 1 ===============
Clign1:
	Do While PA0=0
	PC0=1 : Pause 500 : PC0=0 : Pause 500
	Loop
	Return
Rem ===== SEQUENCE No 2 ===============
Clign2:
	Do While PA1=0
	PORTC=255 : Pause 500 : PORTC=0 : Pause 500
	Loop
	Return
Rem ===== SEQUENCE No 3 ===============
Clign3:
	J=1
	Do While PA2=0
	PORTC=J
	Pause 50
	J=J+1
	If J=256 then J=1
	Loop
	Return

Rem ===========================================================================
Rem ========================= FIN DU PROGRAMME ================================
Rem ===========================================================================
End
