
//------------------------------------------------------------------------------
// TITLE        : UART - EMIT AND RECEIVE BUFFER
// FILES        :
// REVISION     : 1.0
// LAST UPDATE  : 18/08/2004
// TARGET       : -
// CRYSTAL      : -
// AUTHOR       : Yann Leidwanger
// EMAIL        : yann.leidwanger@wanadoo.fr
//------------------------------------------------------------------------------

// for 7.3728MHz crystal
#define baud_9600       0x2f
#define baud_19200      0x17
#define baud_38400      0x0b
#define baud_57600      0x07

void init_uart_rx_rxcie_tx(void);
void uart_emit_char(unsigned char ucar);
void uart_emit_crlf(void);
void uart_emit_str(unsigned char *ubuf, unsigned char usize);

//------------------------------------------------------------------------------
// init uart : emit, receive, receive interrupt
void init_uart_rx_rxcie_tx(void)
{
 outp(baud_57600, UBRR);
 outp((1 << RXEN) | (1 << RXCIE) | (1 << TXEN), UCR);
}

// emit data
void uart_emit_char(unsigned char ucar)
{
 loop_until_bit_is_set(USR, UDRE);
 outp(ucar, UDR);
}

// emit "carriage return" + "line feed"
void uart_emit_crlf(void)
{
 loop_until_bit_is_set(USR, UDRE);
 outp(0x0D, UDR);
 loop_until_bit_is_set(USR, UDRE);
 outp(0x0A, UDR);
}

// emit string
void uart_emit_str(unsigned char *ubuf, unsigned char usize)
{
 unsigned char i;

 for (i = 0; i < usize + 1; i++)
    {
     loop_until_bit_is_set(USR, UDRE);
     outp(ubuf[i], UDR);
    }
}

/*------------------------------------------------------------------------------
// EXAMPLE
//
// global
unsigned char rec_buf[16];			// receive buffer
unsigned char rec_cpt_m = 0, rec_cpt_u = 0;

int main (void)
{
init_uart_rx_rxcie_tx();
sei();						// enable global interrupts

uart_emit_crlf();
uart_emit_str("Developpement C pour AVR sous Debian GNU/Linux", 46);
uart_emit_crlf();
uart_emit_str("Yann Leidwanger - octobre 2002", 30);
uart_emit_crlf();

while (1)
 {
  if (rec_cpt_m != rec_cpt_u)
    {
     uart_emit_char(rec_buf[rec_cpt_m]);	// echo
     rec_cpt_m++;
     rec_cpt_m &= 0x0F;
    }
 }
}

// receive interrupt
SIGNAL(SIG_UART_RECV)
{
 rec_buf[rec_cpt_u] = inp(UDR);
 rec_cpt_u++;
 rec_cpt_u &= 0x0F;
}
------------------------------------------------------------------------------*/





















