//------------------------------------------------------------------------------
// TITLE        : telecommande robotique - functions
// REVISION     : 1.5
// LAST UPDATE  : 02/10/2004
// AUTHOR       : Yann Leidwanger
// EMAIL        : yann.leidwanger@wanadoo.fr
//------------------------------------------------------------------------------

#define led_port        PORTD
#define led1            PD4
#define led2            PD5
#define led3            PD6
#define led4            PD7

#define trans_port      PORTD
#define trans_txen      PD2
#define trans_rxen      PD3

// buffer format
// 0x55 0x55 0x55 0x55 0x5a 0xa5                // start of buffer
// command_low command_high data_low data_high  // buffer
// 0x69 0x96                                    // end of buffer

// global
static volatile unsigned char rec_buf[16];	// receive buffer
static volatile unsigned char rec_cpt_m = 0;    // main ptr
static volatile unsigned char rec_cpt_u = 0;    // interrupt ptr
static volatile unsigned char command;          // command form emitter
static volatile unsigned char data;             // data from emitter
static volatile unsigned char command_low;      // manchester command low
static volatile unsigned char command_high;     // manchester command high
static volatile unsigned char data_low;         // manchester data low
static volatile unsigned char data_high;        // manchester data high
static volatile unsigned char temp_port;        // test
static volatile unsigned char cpt55 = 0;        // synchro counter
static volatile unsigned char data_cpt = 0;     // data counter
static volatile unsigned char flag = 0;         // 0 -> no synchro
                                                // 1 -> synchro 0x55
                                                // 2 -> 0xa5
                                                // 3 -> 0x5a
                                                // 4 -> data1
                                                // 5 -> data2
                                                // 6 -> data3
                                                // 7 -> data4
                                                // 8 -> 0x69
                                                // 9 -> 0x96


void init_syst(void)
{
outp(0x00, DDRA);       // porta input
outp(0xff, PORTA);      // porta pull-up

outp(0x0B, DDRB);       // pb0, pb1, pb3 output
outp(0x0B, PORTB);      // init adc signals

outp(0xff, DDRC);       // portc output
outp(0x00, PORTC);      // portc = 0x00

outp(0xfc, DDRD);       // portd output (+uart)
outp(0x0c, PORTD);      // leds OFF, init trans_hf signals
}

void mode_receive(void)
{
 sbi(trans_port, trans_txen);           // disable tx
 cbi(trans_port, trans_rxen);           // enable rx
}

void exec_buffer(void)
{
 unsigned int i;

 i = command_high;
 i = i << 8;
 i |= command_low;
 command = manchester_decode(i);        // decode command
 i = data_high;
 i = i << 8;
 i |= data_low;
 data = manchester_decode(i);           // decode data
 outp(data, PORTC);                     // write outputs
 if (command == 1)
  {
   temp_port = inp(PORTD);
   temp_port &= 0x0f;
   data = data << 4;
   temp_port |= data;
   outp(temp_port, PORTD);              // write control leds
  }
 if (command == 2)
  {
   temp_port = inp(PORTD);
   temp_port &= 0x0f;
   data &= 0xf0;
   temp_port |= data;
   outp(temp_port, PORTD);              // write control leds
  }
 data_cpt = 0;                          // re-init ptrs
 cpt55 = 0;
 flag = 0;
}

void check_rec_buf(void)
{
 if (data_cpt == 0)
  {
   if (rec_buf[rec_cpt_m] == 0x55)              // 0x55 ?
    {
     cpt55++;                                   // inc counter
     flag = 1;
    }
   else if (rec_buf[rec_cpt_m] == 0x5a)         // 0x5a ?
    {
     if ((flag == 1) && (cpt55 > 3))            // synchro ok ?
      flag = 2;                                 // yes
     else
      {
       flag = 0;                                // no
       cpt55 = 0;
      }
    }
   else if (rec_buf[rec_cpt_m] == 0xa5)         // 0xa5 ?
    {
     if (flag == 2)
      data_cpt = 1;                             // yes
     else
      flag = 0;                                 // no
    }
  }
 else
  {
   if (data_cpt == 1)
    command_low = rec_buf[rec_cpt_m];           // byte 1
   if (data_cpt == 2)
    command_high = rec_buf[rec_cpt_m];          // byte 2
   if (data_cpt == 3)
    data_low = rec_buf[rec_cpt_m];              // byte 3
   if (data_cpt == 4)
    data_high = rec_buf[rec_cpt_m];             // byte 4
   if (data_cpt == 5)
    if (rec_buf[rec_cpt_m] != 0x69)             // 0x69 ?
     {
      data_cpt = 0;                             // no
      cpt55 = 0;
      flag = 0;
     }
   if (data_cpt == 6)
    {
     if (rec_buf[rec_cpt_m] != 0x96)            // 0x96 ?
      {
       data_cpt = 0;                            // no
       cpt55 = 0;
       flag = 0;
      }
     else
      {
       exec_buffer();                           // yes
      }
    }
   data_cpt++;                                  // inc byte counter
   if (data_cpt == 7)
    data_cpt = 0;                               // re-init byte counter
  }
}



