//------------------------------------------------------------------------------
// TITLE        : manchester coding / decoding
// REVISION     : 1.1
// LAST UPDATE  : 22/09/2004
// AUTHOR       : Yann Leidwanger
// EMAIL        : yann.leidwanger@wanadoo.fr
//------------------------------------------------------------------------------

unsigned int manchester_code(unsigned char);
unsigned char manchester_decode(unsigned int);

//------------------------------------------------------------------------------

unsigned int manchester_code(unsigned char data)
{
 unsigned char i;                       // loop counter
 unsigned int j;                        // 16bit result

 j = 0x0000;                            // init
 
 for (i = 0; i < 8; i++)
  {
   if ((data & 0x01) == 0x01)           // test lsb
     j |= 0x8000;                       // lsb = 1 -> 10
   else
     j |= 0x4000;                       // lsb = 0 -> 01
   if (i != 7)
    j = j >> 2;                         // shift result
   data = data >> 1;                    // shift data
  }

 return(j);                             // end
}

unsigned char manchester_decode(unsigned int data)
{
 unsigned char i;                       // loop counter
 unsigned char result;                  // 8bit result

 result = 0x00;                         // init
 
 for (i = 0; i < 8; i++)
  {
   if ((data & 0x0001) == 0x01)         // test lsb1 & lsb0
    result &= 0x7f;                     // lsb1=0 & lsb0=1 -> 0
   else
    result |= 0x80;                     // lsb1=1 & lsb0=0 -> 1
   if (i != 7)
    result = result >> 1;               // shift result
   data = data >> 2;                    // shift data
  }

 return(result);
}

/*------------------------------------------------------------------------------
EXAMPLE

unsigned char var8;
unsigned int result16;

var8 = 0x35;

result16 = manchester_code(var8);



unsigned int var16;
unsigned char result8;

var16 = 0x658d;

result8 = manchester_decode(var16);

------------------------------------------------------------------------------*/
