//------------------------------------------------------------------------------
// TITLE        : remote control for robot - emitter functoins
// REVISION     : 1.0
// LAST UPDATE  : 22/09/2004
// AUTHOR       : Yann Leidwanger
// EMAIL        : yann.leidwanger@wanadoo.fr
//------------------------------------------------------------------------------

void init_syst(void);
void transmit_commad(unsigned char, unsigned char);

#define led_port        PORTA
#define led_ddr         DDRA
#define led_pin         PINA

#define led_trans_port  PORTB
#define led_trans_ddr   DDRB
#define led_trans_pin   PINB
#define led_emit        PB0     // red led
#define led_receive     PB1     // green led

#define inputs_port     PORTC
#define inputs_ddr      DDRC
#define inputs_pin      PINC
#define key_a           PC0
#define key_b           PC1
#define key_c           PC2
#define key_d           PC3
#define joy_left        PC4
#define joy_up          PC5
#define joy_right       PC6
#define joy_down        PC7

#define trans_port      PORTD   // transceiver
#define trans_ddr       DDRD
#define trans_pin       PIND
#define trans_txen      PD2
#define trans_rxen      PD3

void init_syst(void)
{
outp(0xff, DDRA);       // porta output
outp(0xff, PORTA);      // leds off

outp(0x03, DDRB);       // pb0, pb1 output
outp(0xfc, PORTB);      // pull-up res

outp(0x00, DDRC);       // portc input
outp(0xff, PORTC);      // pull-up res

outp(0x0c, DDRD);       // portd output (transceiver)
outp(0xff, PORTD);      // pull-up res + init trans_hf signals
}

void transmit_command(unsigned char command, unsigned char data)
{
 unsigned int i;                                // manchester coding/decoding
 unsigned char low_command;                     // low byte command
 unsigned char high_command;                    // high byte command
 unsigned char low_data;                        // low byte data
 unsigned char high_data;                       // high byte data

 i = manchester_code(command);                  // coding command
 low_command = i;
 high_command = i >> 8;

 i = manchester_code(data);                     // coding data
 low_data = i;
 high_data = i >> 8;

 sbi(led_trans_port, led_emit);                 // red led on
 cbi(trans_port, trans_txen);                   // enable transmitter
 uart_emit_char(0x55);		                // synchro
 uart_emit_char(0x55);		                // synchro
 uart_emit_char(0x55);		                // synchro
 uart_emit_char(0x55);		                // synchro
 uart_emit_char(0x5a);		                // start of buffer
 uart_emit_char(0xa5);		                // start of buffer
 uart_emit_char(low_command);                   // command high
 uart_emit_char(high_command);	                // command low
 uart_emit_char(low_data);	                // data high
 uart_emit_char(high_data);	                // data low
 uart_emit_char(0x69);		                // end of buffer
 uart_emit_char(0x96);		                // end of buffer
 sbi(trans_port, trans_txen);                   // disable transmitter
 cbi(led_trans_port, led_emit);                 // red led off
}

