//------------------------------------------------------------------------------
// TITLE        : telecommande robotique - main
// REVISION     : 1.4
// LAST UPDATE  : 02/10/2004
// TARGET       : AT90S8515
// CRYSTAL      : 7.3728MHz
// AUTHOR       : Yann Leidwanger
// EMAIL        : yann.leidwanger@wanadoo.fr
//------------------------------------------------------------------------------

#define AVR_AT90S8515

#include <io8515.h>
#include <progmem.h>
#include <io.h>
#include <interrupt.h>
#include <sig-avr.h>

#include "uart_buffer.h"                // uart functions
#include "manchester.h"                 // manchester coding/decoding
#include "receiver_functions.h"         // othes functions

int main(void)
{
 init_syst();                           // system initialisation
 mode_receive();                        // receive mode for hf transceiver

 init_uart_rx_rxcie_tx();               // enable uart
 sei();				        // enable global interrupts

 while(1)
  {
   if (rec_cpt_m != rec_cpt_u)          // received char ?
    {
     check_rec_buf();                   // check buffer
     rec_cpt_m++;                       // inc ptr
     rec_cpt_m &= 0x0F;                 // re-init ptr
    }
   // background tasks
   
  }                                     // main loop end
 return(0);
}

// receive interrupt
SIGNAL(SIG_UART_RECV)
{
 rec_buf[rec_cpt_u] = inp(UDR);         // read received char
 rec_cpt_u++;                           // inc ptr
 rec_cpt_u &= 0x0F;                     // re-init ptr
}


