//------------------------------------------------------------------------------
// TITLE        : remote control for robot - emitter
// REVISION     : 1.1
// LAST UPDATE  : 03/10/2004
// TARGET       : AT90S8515
// CRYSTAL      : 7.3728MHz
// AUTHOR       : Yann Leidwanger
// EMAIL        : yann.leidwanger@wanadoo.fr
//------------------------------------------------------------------------------

#define AVR_AT90S8515

#include <io8515.h>
#include <progmem.h>
#include <io.h>
#include <interrupt.h>
#include <sig-avr.h>

#include "uart_one_char.h"
#include "manchester.h"
#include "emitter_functions.h"

// global
unsigned char rec_car;

int main(void)
{
 unsigned char key_pressed;             // push_button or joystick
 unsigned char remote_command = 0;      // 0 = no command
                                        // 1 = push_buttons
                                        // 2 = joystick
 unsigned char remote_data;             // value for push_buttons, joystisk
 
 init_syst();
 init_uart_rx_rxcie_tx();
 sei(); 				// enable global interrupts

 while(1)
  {
   key_pressed = inp(inputs_pin);       // read inputs

   if ((key_pressed & 0x0f) < 0x0f)     // push_button
    {
     remote_command = 1;
     remote_data = key_pressed;
    }

   if ((key_pressed & 0xf0) < 0xf0)     // joystick
    {
     remote_command = 2;
     remote_data = key_pressed;
    }

   if (remote_command != 0)             // transmit buffer
    {
     transmit_command(remote_command, remote_data);
     remote_command = 0;                // re-init command
    }
  }
 return(0);
}

SIGNAL(SIG_UART_RECV)                   // not used yet
{
 rec_car = inp(UDR);
}

