unit uPrefs;

interface

uses
  Inifiles;

type
  TPrefs = record
    ComNumber: integer;
    GraphXMin: integer;
    GraphXMax: integer;
    ShowNoData: boolean;
  end;

var
  Prefs: TPrefs;


procedure Prefs_Load(sFile: string);
procedure Prefs_Save(sFile: string);
procedure Prefs_Apply;

implementation

uses
  frmMain;

procedure Prefs_Load(sFile: string);
var
  ini: TIniFile;
begin
  ini := TIniFile.Create(sFile);
  try
    Prefs.ComNumber := ini.ReadInteger('Com', 'ComNumber', 1);
    Prefs.GraphXMin := ini.ReadInteger('Graph', 'XMin', -1);
    Prefs.GraphXMax := ini.ReadInteger('Graph', 'XMax', 400);
    Prefs.ShowNoData := ini.ReadBool('Misc', 'ShowNoData', true);
  finally
    ini.Free;
  end;
  Prefs_Apply;
end;

procedure Prefs_Save(sFile: string);
var
  ini: TIniFile;
begin
  if not bPrefsCanSave then exit;
  ini := TIniFile.Create(sFile);
  try
    ini.WriteInteger('Com', 'ComNumber', Prefs.ComNumber);
    ini.WriteInteger('Graph', 'XMin', Prefs.GraphXMin);
    ini.WriteInteger('Graph', 'XMax', Prefs.GraphXMax);
    ini.WriteBool('Misc', 'ShowNoData', Prefs.ShowNoData);
  finally
    ini.Free;
  end;
end;

procedure Prefs_Apply;
begin
  // port com
  if bCom1Available and bCom2Available then
  begin
    case Prefs.ComNumber of
      1 : fmMain.ActComSetComNum1Execute(nil);
      2 : fmMain.ActComSetComNum2Execute(nil)
      else fmMain.ActComSetComNum1Execute(nil);
    end;
  end
  else if bCom1Available and (not bCom2Available) then
  begin
    fmMain.ActComSetComNum1Execute(nil);
  end;

  // graph
  with fmMain.Chart1 do
  begin
    LeftAxis.Minimum := Prefs.GraphXMin;
    LeftAxis.Maximum := Prefs.GraphXMax;
  end;

  // misc
  fmMain.ActShowNoData.Checked := Prefs.ShowNoData;
  fmMain.App_GUIRefresh;

end;

end.
