unit uGraph;

interface

uses
  Controls, Dialogs, SysUtils, Graphics;

procedure Graph_Init;
procedure Graph_CheckForSave;
procedure Graph_Open(sFile: string);
procedure Graph_Save(sFile: string);
procedure Graph_Print;
procedure Graph_ExportBitmap(sFile: string);
procedure Graph_ExportMetafile(sFile: string);
procedure Graph_CopyToClipboardBitmap;
procedure Graph_CopyToClipboardMetafile;
procedure Graph_AddNewValue(iVal: integer);

implementation

uses
  uRes, uPrefs,
  frmMain;

procedure Graph_Init;
var
  i: integer;
begin
  fmMain.series1.Clear;
  for i := 0 to pred(iMaxPoints) do
    fmMain.series1.AddXY(i, 0);
end;

procedure Graph_CheckForSave;
var
  SaveResp: Integer;
begin
  if not bGraphModified then exit;
  SaveResp := MessageDlg(sSaveChanges, mtConfirmation, mbYesNoCancel, 0);
  case SaveResp of
    mrYes    : fmMain.ActSaveExecute(nil);
    mrNo     : {Nothing};
    mrCancel : Abort;
  end;
end;

procedure Graph_Open(sFile: string);
var
  i: integer;
  x, y: integer;
  F: TextFile;
  s: string;
begin

  // effacement des points actuels
  fmMain.series1.Clear;
  for i := 0 to pred(iMaxPoints) do
    fmMain.series1.AddXY(i, 0);

  // lecture des valeurs de points dans le fichier
  try
    AssignFile(F, sFile);
    Reset(F);
    while not EOF(F) do
    begin
      Readln(F, s);
      try
        Graph_AddNewValue(strToInt(s));
      except
      end;
    end;
  finally
    CloseFile(F);
  end;
  fmMain.App_SetGraphFileName(sFile);
  fmMain.StatusBar1.panels[idxSBFreq].text := '-';
  bGraphModified := False;
end;

procedure Graph_Save(sFile: string);
var
  i: integer;
  x, y: integer;
  F: TextFile;
  s: string;
begin

  // sauvegarde des valeurs de points dans le fichier
  try
    AssignFile(F, sFile);
    Rewrite(F);
    for i := 0 to pred(fmMain.Series1.Count) do
    begin
      s := intToStr(round(fmMain.series1.YValues[i]));
      Writeln(F, s);
    end;
  finally
    CloseFile(F);
  end;

  fmMain.App_SetGraphFileName(sFile);
  bGraphModified := False;
end;

procedure Graph_Print;
begin
  try
    fmMain.Chart1.Print;
  except
  end;
end;

procedure Graph_ExportBitmap(sFile: string);
begin
  try
    fmMain.Chart1.SaveToBitmapFile(sFile);
  except
    showMessage(sErrExportBitmapFailed);
  end;
end;

procedure Graph_ExportMetafile(sFile: string);
begin
  try
    fmMain.Chart1.SaveToMetafile(sFile);
  except
    showMessage(sErrExportMetafileFailed);
  end;
end;

procedure Graph_CopyToClipboardBitmap;
begin
  try
    fmMain.Chart1.CopyToClipboardBitmap;
  except
    showMessage(sErrCopyToClipboardBitmapFailed);
  end;
end;

procedure Graph_CopyToClipboardMetafile;
begin
  try
    fmMain.Chart1.CopyToClipboardMetafile(false);
  except
    showMessage(sErrCopyToClipboardMetafileFailed);
  end;
end;

{
Graph_AddNewValue(xxx) est la procdure qui permet d'ajouter  la courbe du
graphe, la dernire valeur de frquence mesure. Cette procdure assure d'une
part le dcalage d'un cran des valeurs existantes, la suppression de la valeur
la plus ancienne, puis l'ajout de la valeur la plus rcente. Cette faon de
faire permet de conserver un nombre de points constant et d'obtenir un trac
mobile, avec la valeur la plus rcente toujours  droite.
}
procedure Graph_AddNewValue(iVal: integer);
var
  idx: integer;
  i,
  x, y: integer;
begin
  // indication de la derniere frequence lue dans la barre de statuts
  fmMain.StatusBar1.panels[idxSBFreq].text := intToStr(iVal) + sUnitHz;

  // decallage des valeurs dans le tableau des valeurs de la serie series1
  for i := pred(pred(iMaxPoints)) downTo 0 do
    fmMain.series1.XValues[i + 1] := fmMain.series1.XValues[i];

  // suppression du premier point du tableau des valeurs deja lues
  fmMain.series1.Delete(0);

  // puis ajout du dernier point
  fmMain.series1.AddXY(iMaxPoints, iVal);

  // si valeur freq nulle, indication en rouge
  if Prefs.ShowNoData then
    fmMain.Chart1.Title.Visible := (iVal < 1);

  bGraphModified := true;
end;



end.
