unit uCom;

interface

uses
  Forms, Controls, Dialogs, SysUtils;

procedure Com_CheckForPortOpened;
procedure Com_SetComNum(iVal: integer);
function  Com_GetDCD: boolean;

{
const
  Com1BaseAddr = $03F8;
  Com2BaseAddr = $02F8;
  Com3BaseAddr = $03E8;   // $03E8 pour IBM PC, $3220 for IBM PS/2
  Com4BaseAddr = $02E8;   // $02E8 pour IBM PC, $3228 for IBM PS/2
}

implementation

uses
  uRes, uPrefs,
  frmMain;

procedure Com_CheckForPortOpened;
begin
  if not fmMain.ApdComPort1.open then
  begin
    showMessage(format(sErrComPortNotOpened, [fmMain.ApdComPort1.ComNumber]));
    abort;
  end;
end;

procedure Com_SetComNum(iVal: integer);
var
  SaveCursor: TCursor;
begin
  fmMain.StatusBar1.panels[idxStatusText].text := sComSetParams;
  fmMain.StatusBar1.panels[idxSBComNum].text := 'Com ' + intToStr(iVal);
  try
    SaveCursor := screen.cursor;
    screen.cursor := crHourGlass;
  try
    fmMain.ApdComPort1.Open := false;
    fmMain.ApdComPort1.ComNumber := iVal;
    fmMain.Delay(500);
    fmMain.ApdComPort1.Open := true;
    fmMain.StatusBar1.panels[idxSBComNum].text :=
      fmMain.StatusBar1.panels[idxSBComNum].text + ' - Ouvert';
    Prefs.ComNumber := iVal;
  except
    fmMain.StatusBar1.panels[idxSBComNum].text :=
      fmMain.StatusBar1.panels[idxSBComNum].text + ' - Ferm';
  end;
  finally
    screen.cursor := SaveCursor;
    fmMain.StatusBar1.panels[idxStatusText].text := '';
  end;
end;

{
Com_GetDCD est la fonction qui va permettre de lire l'tat de l'entre DCD.
Cette fonction ne comprend qu'une seule ligne de code, grace  l'emploi du
composant apdComPort.
Sans ce composant, nous aurions pu utiliser une fonction base sur du code
assembleur pour lire l'tat de la ligne DCD et la stocker dans la variable Data,
mais cette faon de faire peut chouer sous Windows NT (du fait d'une plus
grande rigueur du systme d'exploitation concernant les accs en mmoire,
quand il ne s'agit pas tout simplement d'une restriction des droits d'utilisateur).
}

function  Com_GetDCD: boolean;
begin
  result := fmMain.ApdComPort1.DCD;
end;


end.
