{

Logiciel LiesDetector
Copyrights Remy Mallard
remy.mallard@wanadoo.Fr

Pour pouvoir recompiler ce code source, installer au prealable
les composants VCL tiers suivants :
- AsyncPro (Turbopower) version 4 au minimu
- Jedi (JCL et JVCL) JCL version 1.90 au minimum, JVCLversion 3 au minimu
Ces composants sont disponibles sur le site internet SourceForge.
http://sourceforge.net/

}

unit frmMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ImgList, ActnList, ComCtrls, ToolWin, ExtCtrls, TeeProcs, IniFiles,
  TeEngine, Chart, ExtDlgs, Series, OoMisc, AdPort, JvComponent, JvThread,
  AwUser, AwWin32

  ;

type
  TfmMain = class(TForm)
    ActionList1: TActionList;
    ActCaptureStart: TAction;
    ImageList1: TImageList;
    MainMenu1: TMainMenu;
    Fichier1: TMenuItem;
    Quitter1: TMenuItem;
    ActAppClose: TAction;
    ActGraphExportBitmap: TAction;
    ActGraphExportMetafile: TAction;
    ActGraphPrint: TAction;
    ExporterBitmapbmp1: TMenuItem;
    ExporterMtafichierwmf1: TMenuItem;
    Imprimer1: TMenuItem;
    Acquisition1: TMenuItem;
    Dmarrer1: TMenuItem;
    ActCaptureStop: TAction;
    Arrter1: TMenuItem;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton7: TToolButton;
    N1: TMenuItem;
    N2: TMenuItem;
    ToolButton6: TToolButton;
    ToolButton8: TToolButton;
    ToolButton9: TToolButton;
    ToolButton10: TToolButton;
    ActNew: TAction;
    ActOpen: TAction;
    ActSave: TAction;
    ActSaveAs: TAction;
    StatusBar1: TStatusBar;
    Chart1: TChart;
    PrintDialog1: TPrintDialog;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    Nouveau1: TMenuItem;
    Ouvrir1: TMenuItem;
    Sauver1: TMenuItem;
    Sauversous1: TMenuItem;
    N3: TMenuItem;
    ActAppAbout: TAction;
    Aide1: TMenuItem;
    Indexdelaide1: TMenuItem;
    N4: TMenuItem;
    about1: TMenuItem;
    ActAppHelpIndex: TAction;
    ApdComPort1: TApdComPort;
    ActComSetComNum2: TAction;
    ActComSetComNum1: TAction;
    Port1: TMenuItem;
    mnuCom1: TMenuItem;
    mnuCom2: TMenuItem;
    ActGraphSetXMin: TAction;
    ActGraphSetXMax: TAction;
    Graphe1: TMenuItem;
    Minchellehorizontalle1: TMenuItem;
    Maxchellehorizontalle1: TMenuItem;
    jvThreadCapture: TJvThread;
    Series1: TLineSeries;
    ActShowNoData: TAction;
    N5: TMenuItem;
    Afficheravertissementsiaucunedonnereue1: TMenuItem;
    ActGraphCopyToClipboardBitmap: TAction;
    ActGraphCopyToClipboardMetafile: TAction;
    Edition1: TMenuItem;
    CopierBitmap1: TMenuItem;
    CopierMetafile1: TMenuItem;
    ActGraphSetXAuto: TAction;
    ActGraphSetXDefault: TAction;
    Echelleverticalepardfaut1: TMenuItem;
    Echelleverticalepardfaut2: TMenuItem;
    ActAppReadme: TAction;
    Lisezmoi1: TMenuItem;
    N6: TMenuItem;
    procedure ActAppCloseExecute(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ActCaptureStartExecute(Sender: TObject);
    procedure ActCaptureStopExecute(Sender: TObject);
    procedure ActGraphExportBitmapExecute(Sender: TObject);
    procedure ActGraphExportMetafileExecute(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure ActAppAboutExecute(Sender: TObject);
    procedure ActComSetComNum1Execute(Sender: TObject);
    procedure ActComSetComNum2Execute(Sender: TObject);
    procedure ActGraphPrintExecute(Sender: TObject);
    procedure ActNewExecute(Sender: TObject);
    procedure ActOpenExecute(Sender: TObject);
    procedure ActSaveAsExecute(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ActGraphSetXMinExecute(Sender: TObject);
    procedure ActGraphSetXMaxExecute(Sender: TObject);
    procedure jvThreadCaptureFinish(Sender: TObject);
    procedure jvThreadCaptureExecute(Sender: TObject; params: Pointer);
    procedure ActSaveExecute(Sender: TObject);
    procedure ActShowNoDataExecute(Sender: TObject);
    procedure ActGraphCopyToClipboardBitmapExecute(Sender: TObject);
    procedure ActGraphCopyToClipboardMetafileExecute(Sender: TObject);
    procedure ActGraphSetXAutoExecute(Sender: TObject);
    procedure ActGraphSetXDefaultExecute(Sender: TObject);
    procedure ActAppReadmeExecute(Sender: TObject);
  private
    procedure ReadData;
    function App_CanWriteToAppPath(sPath: string): boolean;
    procedure App_ExecFile(sFile: string);
    procedure Com_GetComList;
    { Dclarations prives }
  public
    { Dclarations publiques }
    procedure Delay(ms: Longword);
    procedure App_Init;
    procedure App_GUIRefresh;
    procedure App_SetGraphFileName(sFile: String);
  end;

const
  //Com_MaxPort = 2;
  Com_UseDispatcherForAvail: Boolean = True;
  Com_ShowPortsInUse: Boolean = True;

var
  fmMain: TfmMain;
  HThreadCapture: THandle;
  bCom1Available, bCom2Available: boolean;
  AppPath,
  AppIniFile,
  AppReadmeFile: string;
  bStopRequest: boolean;
  bThreadIsRunning,
  bCaptureRunning: boolean;   // drapeau d'acquisition en cours
  bGraphModified: boolean;
  FGraphOpenedFile: string;
  bPrefsCanSave: boolean;

implementation

{$R *.DFM}

uses
  uRes, uPrefs, uGraph, uCom,
  frmAbout;

function CP_PortIsAvailable(ComNum: Cardinal): Boolean;

  function MakeComName(const Dest: PChar; const ComNum: Cardinal): PChar;
  begin
    StrFmt(Dest,'\\.\COM%d',[ComNum]);
    MakeComName := Dest;
  end;

var
  ComName : array[0..12] of Char;
  Res : Integer;
  DeviceLayer: TApdBaseDispatcher;
begin
  DeviceLayer := nil;
  try
    if (ComNum = 0) then
      Result := False
    else begin
      if Com_UseDispatcherForAvail then begin
        DeviceLayer  := TApdWin32Dispatcher.Create(nil);
        Res := DeviceLayer.OpenCom(MakeComName(ComName,ComNum), 64, 64);
        if (Res < 0) then
          if Com_ShowPortsInUse then
            Result := GetLastError = DWORD(Abs(ecAccessDenied))
          else
            Result := False
        else begin
          Result := True;
          DeviceLayer.CloseCom;
        end;
      end else begin
        Res := CreateFile(MakeComName(ComName, ComNum),
                 GENERIC_READ or GENERIC_WRITE,
                 0,
                 nil,
                 OPEN_EXISTING,
                 FILE_ATTRIBUTE_NORMAL or
                 FILE_FLAG_OVERLAPPED,
                 0);
        if Res > 0 then begin
          CloseHandle(Res);
          Result := True;
        end else begin
          if Com_ShowPortsInUse then
            Result := GetLastError = DWORD(Abs(ecAccessDenied))
          else
            Result := False;
        end;
      end;
    end;
  finally
    if Com_UseDispatcherForAvail then
      DeviceLayer.Free;
  end;
end;

function  CP_GetValidComPortList(var ComList: TStringList): integer;
var
  i : Integer;
  s : string;
begin
  ComList.Clear;
  for i := 1 to MaxComHandles do
  begin
    if CP_PortIsAvailable(i) then
    begin
      S := Format('COM%d', [I]);
      ComList.Add(S);
    end;
  end;
end;

procedure TfmMain.Delay(ms: Longword);
var
  t: Longword;
begin
  t := getTickCount;
  // execution de la boucle Repeat..Until
  // pendant ms millisecondes
  repeat
    application.processMessages;
  until (getTickCount - t) > ms;
end;

procedure TfmMain.App_ExecFile(sFile: string);
var
  SUInfo: TStartupInfo;
  ProcInfo: TProcessInformation;
  CmdLine: string;
begin
  try
    CmdLine := '"Notepad" ' + sFile;
    //CmdLine := '"' + sFile + '"' + Params;
    //CmdLine := sFile;
    FillChar(SUInfo, SizeOf(SUInfo), #0);
    with SUInfo do
    begin
      cb := SizeOf(SUInfo);
      dwFlags := STARTF_USESHOWWINDOW;
      wShowWindow := SW_SHOWDEFAULT;
    end;
    CreateProcess(nil, PChar(CmdLine), nil, nil, FALSE,
                  CREATE_NEW_CONSOLE or NORMAL_PRIORITY_CLASS, nil,
                  PChar(ExtractFilePath(sFile)), SUInfo, ProcInfo);
  except
  end;
end;

procedure TfmMain.FormCreate(Sender: TObject);
begin
  bCaptureRunning := false;
  App_GUIRefresh;
  Graph_Init;
end;

procedure TfmMain.App_Init;
begin
  // chemins d'acces
  AppPath := extractFilePath(application.exeName);
  AppIniFile := changeFileExt(Application.ExeName, '.ini');
  AppReadmeFile := AppPath + 'A_Lire.txt';
  OpenDialog1.InitialDir := AppPath;
  SaveDialog1.InitialDir := AppPath;
  // verification prsence des ports Com
  Com_GetComList;
  // chargement des prfrences utilisateur
  Prefs_Load(AppIniFile);
  // verification possibilite ecriture des prfrences utilisateur
  bPrefsCanSave := App_CanWriteToAppPath(AppPath);
  // divers
  ActNewExecute(nil);
end;

procedure TfmMain.Com_GetComList;
var
  lst: TStringList;
  i: integer;
begin
  lst := TStringList.Create;
  try
    CP_GetValidComPortList(lst);

    //for i := 0 to pred(lst.count) do
      //showmessage(lst[i]);

    bCom1Available := (lst.IndexOf('COM1') > -1);
    bCom2Available := (lst.IndexOf('COM2') > -1);

  finally
    lst.Free;
  end;
end;

procedure TfmMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  // interdit de quitter si acquisition en cours
  canClose := not bCaptureRunning;
end;

procedure TfmMain.ActAppCloseExecute(Sender: TObject);
begin
  // fin du programme
  close;
end;

procedure TfmMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  // proposition sauvegarde si graphe modifie
  Graph_CheckForSave;

  // sauvegarde des options utilisateur
  Prefs_Save(AppIniFile);
end;

function  TfmMain.App_CanWriteToAppPath(sPath: string): boolean;
var
  ini: TIniFile;
begin
  result := false;
  try
    ini := TIniFile.Create(AppIniFile);
    try
      ini.WriteBool('Test', 'WriteToIniTest', true);
      result := true;
    finally
      ini.Free;
    end;
  except
  end;
end;

procedure TfmMain.App_GUIRefresh;
begin
  // interdiction ou autorisation de certaines actions
  // selon l'etat de l'acquisition (demarree ou arretee)
  ActCaptureStop.enabled := bCaptureRunning;
  ActCaptureStart.enabled := not bCaptureRunning;
  ActAppClose.enabled := not bCaptureRunning;
  //ActAppAbout.enabled := not bCaptureRunning;
  ActAppHelpIndex.enabled := not bCaptureRunning;
  ActNew.enabled := not bCaptureRunning;
  ActOpen.enabled := not bCaptureRunning;
  ActSave.enabled := not bCaptureRunning;
  ActSaveAs.enabled := not bCaptureRunning;
  ActGraphPrint.enabled := not bCaptureRunning;
  ActGraphExportBitmap.enabled := not bCaptureRunning;
  ActGraphExportMetafile.enabled := not bCaptureRunning;
  ActGraphSetXAuto.enabled := not bCaptureRunning;
  ActComSetComNum1.enabled := (not bCaptureRunning) and bCom1Available;
  ActComSetComNum2.enabled := (not bCaptureRunning) and bCom2Available;
  // divers raffraichissements de l'interface graphique
  StatusBar1.panels[idxSBFreq].text := '-';
  fmMain.Chart1.Title.Visible := false;
  fmMain.Chart1.Refresh;
end;

procedure TfmMain.ActCaptureStartExecute(Sender: TObject);
begin
  // verification port com ouvert
  Com_CheckForPortOpened ;

  bStopRequest := false;
  bCaptureRunning := true;
  App_GUIRefresh;
  StatusBar1.panels[idxSBFreq].text := '0' + sUnitHz;
  StatusBar1.panels[idxStatusText].text := sCaptureRunning;

  // la lecture des donnees est effectuee dans un thread a part
  try
    HThreadCapture := fmMain.jvThreadCapture.Execute(nil);
    bThreadIsRunning := true;
  except
  end;
end;

procedure TfmMain.ActCaptureStopExecute(Sender: TObject);
const
  iMaxTime = 1000;
var
  t0, t1: integer;
  bTimeEllapsed, bThStopped: boolean;
begin
  bStopRequest := true;

  try
    // demande d'arret du thread
    jvThreadCapture.QuitThread(HThreadCapture);
    // attente jusqu'a arret effectif du thread
    t0 := GetTickCount;
    repeat
      application.processMessages;
      t1 := GetTickCount;
      bThStopped := (not bThreadIsRunning);
      bTimeEllapsed := ((t1 - t0) > iMaxTime);
    until bThStopped or bTimeEllapsed;
  except
  end;

  bCaptureRunning := false;
  StatusBar1.panels[idxStatusText].text := sCaptureStopped;
  App_GUIRefresh;
end;

{
procedure ReadData;

iActualState et iOldState sont deux variables qui sont utilises pour stocker
deux tats conscutifs de l'entre DCD, et qui permettent de dterminer quand
l'tat de l'entre de mesure change (quand l'entre passe de l'tat bas 
l'tat haut et inversement).

iInterval est une constante qui spcifie l'intervalle de temps qui doit sparer
chaque mesure (interval de 1 seconde dans le cas prsent). Cette constante est
associe  l'utilisation des variables T0 et T1.

T0 et T1 sont des variables qui permettent de connatre l'intervalle de temps
coul depuis le dbut de la mesure ou depuis la dernire mesure effectue.
Ces deux variables sont utilises avec la fonction GetTickCount qui est une
fonction de Windows (prcisment contenue dans kernel32 pour les connaisseurs),
et qui permet de connatre le nombre de millisecondes coules depuis le
dmarrage de Windows. Si par exemple on appelle la fonction GetTickCount 1h20
aprs le dmarrage de Windows, la valeur obtenue est 4800000
(80 min x 60 sec x 1000). Si on appelle cette mme fonction 50ms plut tard, la
valeur obtenue sera 4800050. Le principe retenu est donc l'utilisation en boucle
de cette fonction, afin de dterminer prcisment quand l'intervalle de temps
atteint la valeur de la constante iInterval (1000ms). Une fois cet intervalle
atteint, on regarde le nombre de fois que l'entre de mesure a chang d'tat
(cette valeur est contenue dans la variable iEdgeCount), on laffiche dans le
graphe aprs lavoir divise par deux, et on donne  la variable T0 une valeur
gale  la valeur de T1 pour commencer une nouvelle mesure.

iEdgeCount est une variable qui permet de stocker le nombre de transitions
(fronts montants et descendant) ayant lieu sur la ligne DCD du port srie.

iFreq est une variable qui permet de stocker la valeur de la frquence, cette
valeur est gale  la moiti de la valeur stocke dans la variable iEdgeCount.


}

procedure TfmMain.ReadData;
const
  iInterval = 1000; // 1000ms, soit 1s
var
  T0, T1: integer;
  iOldState, iActualState: boolean;
  iEdgeCount, iFreq: integer;
begin
  // remarque : la procedure ReadData
  // est executee dans un thread a part

  iEdgeCount := 0;
  T0 := GetTickCount;

  repeat

    Application.processMessages;

    // lecture de l'etat actuel de l'entree DCD du port com
    iActualState := Com_GetDCD;

    // comparaison de l'etat actuel avec l'etat precedemment enregistre
    // si different, incrementation du compteur iEdgeCount
    if iActualState <> iOldState then
    begin
      iOldState := iActualState;
      inc(iEdgeCount);
    end;

    // lecture de l'interval de temps ecoule
    // si temps ecoule > iInterval (1s), ajout d'une nouvelle valeur au graphe
    T1 := GetTickCount;
    if (T1 - T0) > iInterval then
    begin

      // Frequence = moitie du nombre de fronts montants et descendants
      iFreq := iEdgeCount div 2;

      // ajout de la nouvelle valeur au graphe
      Graph_AddNewValue(iFreq);

      // remise a zero du compteur
      iEdgeCount := 0;
      T0 := GetTickCount;

    end;

  until bStopRequest;
  {
  BStopRequest est une variable de type boolean dont la valeur passe  TRUE
  quand l'utilisateur clique sur le bouton Arrter. A cet instant, la boucle de
  lecture Repeat..Until prend fin.
  }

end;

procedure TfmMain.ActGraphExportBitmapExecute(Sender: TObject);
begin
  // export du graphe dans un fichier image bitmap
  with SaveDialog1 do
  begin
    Filter := 'Bitmap (*.bmp)|*.bmp';
    DefaultExt := 'bmp';
    FileName := sFileNew;
    if execute then
      Graph_ExportBitmap(FileName);
  end;
end;

procedure TfmMain.ActGraphExportMetafileExecute(Sender: TObject);
begin
  // export du graphe dans un fichier image vectoriel
  with SaveDialog1 do
  begin
    Filter := 'Metafile (*.wmf)|*.wmf';
    DefaultExt := 'wmf';
    FileName := sFileNew;
    if execute then
      Graph_ExportMetafile(FileName);
  end;
end;

procedure TfmMain.ActGraphPrintExecute(Sender: TObject);
begin
  // impression papier du graph
  with PrintDialog1 do
  begin
    if execute then
      Graph_Print;
  end;
end;

procedure TfmMain.ActAppAboutExecute(Sender: TObject);
var
  frm: TFmAbout;
begin
  // affichage boite de dialogue "A propos"
  frm := TFmAbout.Create(self);
  try
    frm.showModal;
  finally
    frm.Free;
  end;
end;

procedure TfmMain.ActComSetComNum1Execute(Sender: TObject);
begin
  // utilisation du port com 1
  Com_SetComNum(1);
  ActComSetComNum1.Checked := true;
  ActComSetComNum2.Checked := false;
end;

procedure TfmMain.ActComSetComNum2Execute(Sender: TObject);
begin
  // utilisation du port com 2
  Com_SetComNum(2);
  ActComSetComNum1.Checked := false;
  ActComSetComNum2.Checked := true;
end;

procedure TfmMain.ActNewExecute(Sender: TObject);
begin
  Graph_CheckForSave;
  Graph_Init;
  App_SetGraphFileName(sUntitled);
  bGraphModified := false;
end;

procedure TfmMain.App_SetGraphFileName(sFile: String);
begin
  FGraphOpenedFile := sFile;
  Caption := Format('%s - [%s]', [sMainTitle, ExtractFileName(sFile)]);
end;

procedure TfmMain.ActOpenExecute(Sender: TObject);
begin
  Graph_CheckForSave;
  with OpenDialog1 do
  begin
    Filter := 'Donnes (*.dat)|*.dat';
    DefaultExt := 'dat';
    if execute then
      Graph_Open(FileName);
  end;
end;

procedure TfmMain.ActSaveExecute(Sender: TObject);
begin
  if FGraphOpenedFile = sUntitled then
    ActSaveAsExecute(nil)
  else
  begin
    Graph_Save(FGraphOpenedFile);
    bGraphModified := False;
  end;
end;

procedure TfmMain.ActSaveAsExecute(Sender: TObject);
begin
  with SaveDialog1 do
  begin
    Filter := 'Donnes (*.dat)|*.dat';
    DefaultExt := 'dat';
    if Execute then
    begin
      Graph_Save(FileName);
      App_SetGraphFileName(FileName);
      bGraphModified := False;
    end;
  end;
end;

procedure TfmMain.ActGraphSetXMinExecute(Sender: TObject);
var
  sVal: string;
begin
  sVal := intToStr(round(Chart1.LeftAxis.minimum));
  if not inputQuery('Min chelle verticale', 'Valeur (-1..10000)', sVal) then exit;
  try
    Chart1.LeftAxis.minimum := strToInt(sVal);
  except
    Chart1.LeftAxis.minimum := -1;
  end;
  Prefs.GraphXMin := round(Chart1.LeftAxis.minimum);
end;

procedure TfmMain.ActGraphSetXMaxExecute(Sender: TObject);
var
  sVal: string;
begin
  sVal := intToStr(round(Chart1.LeftAxis.maximum));
  if not inputQuery('Min chelle verticale', 'Valeur (1..10000)', sVal) then exit;
  try
    Chart1.LeftAxis.maximum := strToInt(sVal);
  except
    Chart1.LeftAxis.maximum := 400;
  end;
  Prefs.GraphXMax := round(Chart1.LeftAxis.maximum);
end;

procedure TfmMain.jvThreadCaptureFinish(Sender: TObject);
begin
  bThreadIsRunning := false;
end;

procedure TfmMain.jvThreadCaptureExecute(Sender: TObject; params: Pointer);
begin
  ReadData;
end;

procedure TfmMain.ActShowNoDataExecute(Sender: TObject);
begin
  ActShowNoData.Checked := not ActShowNoData.Checked;
  Prefs.ShowNoData := ActShowNoData.Checked;
  if BCaptureRunning and (not ActShowNoData.Checked) then
    fmMain.Chart1.Title.Visible := false;
end;

procedure TfmMain.ActGraphCopyToClipboardBitmapExecute(Sender: TObject);
begin
  Graph_CopyToClipboardBitmap;
end;

procedure TfmMain.ActGraphCopyToClipboardMetafileExecute(Sender: TObject);
begin
  Graph_CopyToClipboardMetafile;
end;

procedure TfmMain.ActGraphSetXAutoExecute(Sender: TObject);
var
  i,
  iVal, iMin, iMax: integer;
begin
  iMin := 300;
  iMax := 0;
  for i := 0 to pred(iMaxPoints) do
  begin
    iVal := round(series1.YValues[i]);
    if iVal > iMax then iMax := iVal;
    if iVal < iMin then iMin := iVal;
  end;
  if iMin >= iMax then
  begin
    iMin := -5;
    iMax := 350;
  end;
  iMin := iMin - 5;
  iMax := iMax + 5;
  try
    Chart1.LeftAxis.minimum := iMin;
    Chart1.LeftAxis.maximum := iMax;
  except
    Chart1.LeftAxis.minimum := -5;
    Chart1.LeftAxis.maximum := 350;
  end;
  Prefs.GraphXMin := iMin;
  Prefs.GraphXMax := iMax;
end;

procedure TfmMain.ActGraphSetXDefaultExecute(Sender: TObject);
begin
  try
    Chart1.LeftAxis.minimum := -5;
    Chart1.LeftAxis.maximum := 350;
  except
  end;
  Prefs.GraphXMin :=-5;
  Prefs.GraphXMax := 350;
end;

procedure TfmMain.ActAppReadmeExecute(Sender: TObject);
begin
  App_ExecFile(AppReadmeFile);
end;

end.
